// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier. The
	// operation returns this identifier in its response.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDocumentClassifierInput"}

	if s.DocumentClassifierArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a document classifier.
	DocumentClassifierProperties *DocumentClassifierProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDocumentClassifier = "DescribeDocumentClassifier"

// DescribeDocumentClassifierRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets the properties associated with a document classifier.
//
//    // Example sending a request using DescribeDocumentClassifierRequest.
//    req := client.DescribeDocumentClassifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier
func (c *Client) DescribeDocumentClassifierRequest(input *DescribeDocumentClassifierInput) DescribeDocumentClassifierRequest {
	op := &aws.Operation{
		Name:       opDescribeDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassifierInput{}
	}

	req := c.newRequest(op, input, &DescribeDocumentClassifierOutput{})

	return DescribeDocumentClassifierRequest{Request: req, Input: input, Copy: c.DescribeDocumentClassifierRequest}
}

// DescribeDocumentClassifierRequest is the request type for the
// DescribeDocumentClassifier API operation.
type DescribeDocumentClassifierRequest struct {
	*aws.Request
	Input *DescribeDocumentClassifierInput
	Copy  func(*DescribeDocumentClassifierInput) DescribeDocumentClassifierRequest
}

// Send marshals and sends the DescribeDocumentClassifier API request.
func (r DescribeDocumentClassifierRequest) Send(ctx context.Context) (*DescribeDocumentClassifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDocumentClassifierResponse{
		DescribeDocumentClassifierOutput: r.Request.Data.(*DescribeDocumentClassifierOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDocumentClassifierResponse is the response type for the
// DescribeDocumentClassifier API operation.
type DescribeDocumentClassifierResponse struct {
	*DescribeDocumentClassifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDocumentClassifier request.
func (r *DescribeDocumentClassifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
