// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListICD10CMInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListICD10CMInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListICD10CMInferenceJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListICD10CMInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListICD10CMInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	ComprehendMedicalAsyncJobPropertiesList []ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListICD10CMInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListICD10CMInferenceJobs = "ListICD10CMInferenceJobs"

// ListICD10CMInferenceJobsRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets a list of InferICD10CM jobs that you have submitted.
//
//    // Example sending a request using ListICD10CMInferenceJobsRequest.
//    req := client.ListICD10CMInferenceJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs
func (c *Client) ListICD10CMInferenceJobsRequest(input *ListICD10CMInferenceJobsInput) ListICD10CMInferenceJobsRequest {
	op := &aws.Operation{
		Name:       opListICD10CMInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListICD10CMInferenceJobsInput{}
	}

	req := c.newRequest(op, input, &ListICD10CMInferenceJobsOutput{})

	return ListICD10CMInferenceJobsRequest{Request: req, Input: input, Copy: c.ListICD10CMInferenceJobsRequest}
}

// ListICD10CMInferenceJobsRequest is the request type for the
// ListICD10CMInferenceJobs API operation.
type ListICD10CMInferenceJobsRequest struct {
	*aws.Request
	Input *ListICD10CMInferenceJobsInput
	Copy  func(*ListICD10CMInferenceJobsInput) ListICD10CMInferenceJobsRequest
}

// Send marshals and sends the ListICD10CMInferenceJobs API request.
func (r ListICD10CMInferenceJobsRequest) Send(ctx context.Context) (*ListICD10CMInferenceJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListICD10CMInferenceJobsResponse{
		ListICD10CMInferenceJobsOutput: r.Request.Data.(*ListICD10CMInferenceJobsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListICD10CMInferenceJobsResponse is the response type for the
// ListICD10CMInferenceJobs API operation.
type ListICD10CMInferenceJobsResponse struct {
	*ListICD10CMInferenceJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListICD10CMInferenceJobs request.
func (r *ListICD10CMInferenceJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
