// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutOrganizationConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of accounts that you want to exclude from an organization
	// config rule.
	ExcludedAccounts []string `type:"list"`

	// The name that you assign to an organization config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata `type:"structure"`

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata `type:"structure"`
}

// String returns the string representation
func (s PutOrganizationConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOrganizationConfigRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutOrganizationConfigRuleInput"}

	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}
	if s.OrganizationCustomRuleMetadata != nil {
		if err := s.OrganizationCustomRuleMetadata.Validate(); err != nil {
			invalidParams.AddNested("OrganizationCustomRuleMetadata", err.(aws.ErrInvalidParams))
		}
	}
	if s.OrganizationManagedRuleMetadata != nil {
		if err := s.OrganizationManagedRuleMetadata.Validate(); err != nil {
			invalidParams.AddNested("OrganizationManagedRuleMetadata", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutOrganizationConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an organization config rule.
	OrganizationConfigRuleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutOrganizationConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutOrganizationConfigRule = "PutOrganizationConfigRule"

// PutOrganizationConfigRuleRequest returns a request value for making API operation for
// AWS Config.
//
// Adds or updates organization config rule for your entire organization evaluating
// whether your AWS resources comply with your desired configurations. Only
// a master account can create or update an organization config rule.
//
// This API enables organization service access through the EnableAWSServiceAccess
// action and creates a service linked role AWSServiceRoleForConfigMultiAccountSetup
// in the master account of your organization. The service linked role is created
// only when the role does not exist in the master account. AWS Config verifies
// the existence of role with GetRole action.
//
// You can use this action to create both custom AWS Config rules and AWS managed
// Config rules. If you are adding a new custom AWS Config rule, you must first
// create AWS Lambda function in the master account that the rule invokes to
// evaluate your resources. When you use the PutOrganizationConfigRule action
// to add the rule to AWS Config, you must specify the Amazon Resource Name
// (ARN) that AWS Lambda assigns to the function. If you are adding an AWS managed
// Config rule, specify the rule's identifier for the RuleIdentifier key.
//
// The maximum number of organization config rules that AWS Config supports
// is 150.
//
// Specify either OrganizationCustomRuleMetadata or OrganizationManagedRuleMetadata.
//
//    // Example sending a request using PutOrganizationConfigRuleRequest.
//    req := client.PutOrganizationConfigRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule
func (c *Client) PutOrganizationConfigRuleRequest(input *PutOrganizationConfigRuleInput) PutOrganizationConfigRuleRequest {
	op := &aws.Operation{
		Name:       opPutOrganizationConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOrganizationConfigRuleInput{}
	}

	req := c.newRequest(op, input, &PutOrganizationConfigRuleOutput{})

	return PutOrganizationConfigRuleRequest{Request: req, Input: input, Copy: c.PutOrganizationConfigRuleRequest}
}

// PutOrganizationConfigRuleRequest is the request type for the
// PutOrganizationConfigRule API operation.
type PutOrganizationConfigRuleRequest struct {
	*aws.Request
	Input *PutOrganizationConfigRuleInput
	Copy  func(*PutOrganizationConfigRuleInput) PutOrganizationConfigRuleRequest
}

// Send marshals and sends the PutOrganizationConfigRule API request.
func (r PutOrganizationConfigRuleRequest) Send(ctx context.Context) (*PutOrganizationConfigRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutOrganizationConfigRuleResponse{
		PutOrganizationConfigRuleOutput: r.Request.Data.(*PutOrganizationConfigRuleOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutOrganizationConfigRuleResponse is the response type for the
// PutOrganizationConfigRule API operation.
type PutOrganizationConfigRuleResponse struct {
	*PutOrganizationConfigRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutOrganizationConfigRule request.
func (r *PutOrganizationConfigRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
