// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StopContactInput struct {
	_ struct{} `type:"structure"`

	// The ID of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopContactInput"}

	if s.ContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactId", 1))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopContactInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StopContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopContactOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopContactOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStopContact = "StopContact"

// StopContactRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Ends the specified contact.
//
//    // Example sending a request using StopContactRequest.
//    req := client.StopContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Client) StopContactRequest(input *StopContactInput) StopContactRequest {
	op := &aws.Operation{
		Name:       opStopContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop",
	}

	if input == nil {
		input = &StopContactInput{}
	}

	req := c.newRequest(op, input, &StopContactOutput{})

	return StopContactRequest{Request: req, Input: input, Copy: c.StopContactRequest}
}

// StopContactRequest is the request type for the
// StopContact API operation.
type StopContactRequest struct {
	*aws.Request
	Input *StopContactInput
	Copy  func(*StopContactInput) StopContactRequest
}

// Send marshals and sends the StopContact API request.
func (r StopContactRequest) Send(ctx context.Context) (*StopContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopContactResponse{
		StopContactOutput: r.Request.Data.(*StopContactOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopContactResponse is the response type for the
// StopContact API operation.
type StopContactResponse struct {
	*StopContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopContact request.
func (r *StopContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
