// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package detective

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DisassociateMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to remove the member account from.
	//
	// The member account's member status in the behavior graph must be ENABLED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembershipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateMembershipInput"}

	if s.GraphArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateMembershipInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GraphArn != nil {
		v := *s.GraphArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GraphArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateMembershipOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisassociateMembership = "DisassociateMembership"

// DisassociateMembershipRequest returns a request value for making API operation for
// Amazon Detective.
//
// Removes the member account from the specified behavior graph. This operation
// can only be called by a member account that has the ENABLED status.
//
//    // Example sending a request using DisassociateMembershipRequest.
//    req := client.DisassociateMembershipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisassociateMembership
func (c *Client) DisassociateMembershipRequest(input *DisassociateMembershipInput) DisassociateMembershipRequest {
	op := &aws.Operation{
		Name:       opDisassociateMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/membership/removal",
	}

	if input == nil {
		input = &DisassociateMembershipInput{}
	}

	req := c.newRequest(op, input, &DisassociateMembershipOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateMembershipRequest{Request: req, Input: input, Copy: c.DisassociateMembershipRequest}
}

// DisassociateMembershipRequest is the request type for the
// DisassociateMembership API operation.
type DisassociateMembershipRequest struct {
	*aws.Request
	Input *DisassociateMembershipInput
	Copy  func(*DisassociateMembershipInput) DisassociateMembershipRequest
}

// Send marshals and sends the DisassociateMembership API request.
func (r DisassociateMembershipRequest) Send(ctx context.Context) (*DisassociateMembershipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateMembershipResponse{
		DisassociateMembershipOutput: r.Request.Data.(*DisassociateMembershipOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateMembershipResponse is the response type for the
// DisassociateMembership API operation.
type DisassociateMembershipResponse struct {
	*DisassociateMembershipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateMembership request.
func (r *DisassociateMembershipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
