// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDirectConnectGatewayAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	AssociatedGatewayId *string `locationName:"associatedGatewayId" type:"string"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token provided in the previous call to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeDirectConnectGatewayAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	DirectConnectGatewayAssociations []DirectConnectGatewayAssociation `locationName:"directConnectGatewayAssociations" type:"list"`

	// The token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDirectConnectGatewayAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDirectConnectGatewayAssociations = "DescribeDirectConnectGatewayAssociations"

// DescribeDirectConnectGatewayAssociationsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Lists the associations between your Direct Connect gateways and virtual private
// gateways. You must specify a Direct Connect gateway, a virtual private gateway,
// or both. If you specify a Direct Connect gateway, the response contains all
// virtual private gateways associated with the Direct Connect gateway. If you
// specify a virtual private gateway, the response contains all Direct Connect
// gateways associated with the virtual private gateway. If you specify both,
// the response contains the association between the Direct Connect gateway
// and the virtual private gateway.
//
//    // Example sending a request using DescribeDirectConnectGatewayAssociationsRequest.
//    req := client.DescribeDirectConnectGatewayAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations
func (c *Client) DescribeDirectConnectGatewayAssociationsRequest(input *DescribeDirectConnectGatewayAssociationsInput) DescribeDirectConnectGatewayAssociationsRequest {
	op := &aws.Operation{
		Name:       opDescribeDirectConnectGatewayAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectConnectGatewayAssociationsInput{}
	}

	req := c.newRequest(op, input, &DescribeDirectConnectGatewayAssociationsOutput{})

	return DescribeDirectConnectGatewayAssociationsRequest{Request: req, Input: input, Copy: c.DescribeDirectConnectGatewayAssociationsRequest}
}

// DescribeDirectConnectGatewayAssociationsRequest is the request type for the
// DescribeDirectConnectGatewayAssociations API operation.
type DescribeDirectConnectGatewayAssociationsRequest struct {
	*aws.Request
	Input *DescribeDirectConnectGatewayAssociationsInput
	Copy  func(*DescribeDirectConnectGatewayAssociationsInput) DescribeDirectConnectGatewayAssociationsRequest
}

// Send marshals and sends the DescribeDirectConnectGatewayAssociations API request.
func (r DescribeDirectConnectGatewayAssociationsRequest) Send(ctx context.Context) (*DescribeDirectConnectGatewayAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDirectConnectGatewayAssociationsResponse{
		DescribeDirectConnectGatewayAssociationsOutput: r.Request.Data.(*DescribeDirectConnectGatewayAssociationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDirectConnectGatewayAssociationsResponse is the response type for the
// DescribeDirectConnectGatewayAssociations API operation.
type DescribeDirectConnectGatewayAssociationsResponse struct {
	*DescribeDirectConnectGatewayAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDirectConnectGatewayAssociations request.
func (r *DescribeDirectConnectGatewayAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
