// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateImageInput struct {
	_ struct{} `type:"structure"`

	// The block device mappings. This parameter cannot be used to modify the encryption
	// status of existing volumes or snapshots. To create an AMI with encrypted
	// snapshots, use the CopyImage action.
	BlockDeviceMappings []BlockDeviceMapping `locationName:"blockDeviceMapping" locationNameList:"BlockDeviceMapping" type:"list"`

	// A description for the new image.
	Description *string `locationName:"description" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// A name for the new image.
	//
	// Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets
	// ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('),
	// at-signs (@), or underscores(_)
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// By default, Amazon EC2 attempts to shut down and reboot the instance before
	// creating the image. If the 'No Reboot' option is set, Amazon EC2 doesn't
	// shut down the instance before creating the image. When this option is used,
	// file system integrity on the created image can't be guaranteed.
	NoReboot *bool `locationName:"noReboot" type:"boolean"`
}

// String returns the string representation
func (s CreateImageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateImageInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateImageOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new AMI.
	ImageId *string `locationName:"imageId" type:"string"`
}

// String returns the string representation
func (s CreateImageOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateImage = "CreateImage"

// CreateImageRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
// is either running or stopped.
//
// If you customized your instance with instance store volumes or EBS volumes
// in addition to the root device volume, the new AMI contains block device
// mapping information for those volumes. When you launch an instance from this
// new AMI, the instance automatically launches with those additional volumes.
//
// For more information, see Creating Amazon EBS-Backed Linux AMIs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CreateImageRequest.
//    req := client.CreateImageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *Client) CreateImageRequest(input *CreateImageInput) CreateImageRequest {
	op := &aws.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	req := c.newRequest(op, input, &CreateImageOutput{})

	return CreateImageRequest{Request: req, Input: input, Copy: c.CreateImageRequest}
}

// CreateImageRequest is the request type for the
// CreateImage API operation.
type CreateImageRequest struct {
	*aws.Request
	Input *CreateImageInput
	Copy  func(*CreateImageInput) CreateImageRequest
}

// Send marshals and sends the CreateImage API request.
func (r CreateImageRequest) Send(ctx context.Context) (*CreateImageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateImageResponse{
		CreateImageOutput: r.Request.Data.(*CreateImageOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateImageResponse is the response type for the
// CreateImage API operation.
type CreateImageResponse struct {
	*CreateImageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateImage request.
func (r *CreateImageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
