// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTrafficMirrorFilterInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the Traffic Mirror filter.
	//
	// TrafficMirrorFilterId is a required field
	TrafficMirrorFilterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficMirrorFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficMirrorFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTrafficMirrorFilterInput"}

	if s.TrafficMirrorFilterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrafficMirrorFilterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTrafficMirrorFilterOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Traffic Mirror filter.
	TrafficMirrorFilterId *string `locationName:"trafficMirrorFilterId" type:"string"`
}

// String returns the string representation
func (s DeleteTrafficMirrorFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTrafficMirrorFilter = "DeleteTrafficMirrorFilter"

// DeleteTrafficMirrorFilterRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror filter.
//
// You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror
// session.
//
//    // Example sending a request using DeleteTrafficMirrorFilterRequest.
//    req := client.DeleteTrafficMirrorFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter
func (c *Client) DeleteTrafficMirrorFilterRequest(input *DeleteTrafficMirrorFilterInput) DeleteTrafficMirrorFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteTrafficMirrorFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteTrafficMirrorFilterOutput{})

	return DeleteTrafficMirrorFilterRequest{Request: req, Input: input, Copy: c.DeleteTrafficMirrorFilterRequest}
}

// DeleteTrafficMirrorFilterRequest is the request type for the
// DeleteTrafficMirrorFilter API operation.
type DeleteTrafficMirrorFilterRequest struct {
	*aws.Request
	Input *DeleteTrafficMirrorFilterInput
	Copy  func(*DeleteTrafficMirrorFilterInput) DeleteTrafficMirrorFilterRequest
}

// Send marshals and sends the DeleteTrafficMirrorFilter API request.
func (r DeleteTrafficMirrorFilterRequest) Send(ctx context.Context) (*DeleteTrafficMirrorFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTrafficMirrorFilterResponse{
		DeleteTrafficMirrorFilterOutput: r.Request.Data.(*DeleteTrafficMirrorFilterOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTrafficMirrorFilterResponse is the response type for the
// DeleteTrafficMirrorFilter API operation.
type DeleteTrafficMirrorFilterResponse struct {
	*DeleteTrafficMirrorFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTrafficMirrorFilter request.
func (r *DeleteTrafficMirrorFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
