// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeManagedPrefixListsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * owner-id - The ID of the prefix list owner.
	//
	//    * prefix-list-id - The ID of the prefix list.
	//
	//    * prefix-list-name - The name of the prefix list.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// One or more prefix list IDs.
	PrefixListIds []string `locationName:"PrefixListId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeManagedPrefixListsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeManagedPrefixListsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeManagedPrefixListsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeManagedPrefixListsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the prefix lists.
	PrefixLists []ManagedPrefixList `locationName:"prefixListSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeManagedPrefixListsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeManagedPrefixLists = "DescribeManagedPrefixLists"

// DescribeManagedPrefixListsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes your managed prefix lists and any AWS-managed prefix lists.
//
// To view the entries for your prefix list, use GetManagedPrefixListEntries.
//
//    // Example sending a request using DescribeManagedPrefixListsRequest.
//    req := client.DescribeManagedPrefixListsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixLists
func (c *Client) DescribeManagedPrefixListsRequest(input *DescribeManagedPrefixListsInput) DescribeManagedPrefixListsRequest {
	op := &aws.Operation{
		Name:       opDescribeManagedPrefixLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeManagedPrefixListsInput{}
	}

	req := c.newRequest(op, input, &DescribeManagedPrefixListsOutput{})

	return DescribeManagedPrefixListsRequest{Request: req, Input: input, Copy: c.DescribeManagedPrefixListsRequest}
}

// DescribeManagedPrefixListsRequest is the request type for the
// DescribeManagedPrefixLists API operation.
type DescribeManagedPrefixListsRequest struct {
	*aws.Request
	Input *DescribeManagedPrefixListsInput
	Copy  func(*DescribeManagedPrefixListsInput) DescribeManagedPrefixListsRequest
}

// Send marshals and sends the DescribeManagedPrefixLists API request.
func (r DescribeManagedPrefixListsRequest) Send(ctx context.Context) (*DescribeManagedPrefixListsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeManagedPrefixListsResponse{
		DescribeManagedPrefixListsOutput: r.Request.Data.(*DescribeManagedPrefixListsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeManagedPrefixListsRequestPaginator returns a paginator for DescribeManagedPrefixLists.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeManagedPrefixListsRequest(input)
//   p := ec2.NewDescribeManagedPrefixListsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeManagedPrefixListsPaginator(req DescribeManagedPrefixListsRequest) DescribeManagedPrefixListsPaginator {
	return DescribeManagedPrefixListsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeManagedPrefixListsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeManagedPrefixListsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeManagedPrefixListsPaginator struct {
	aws.Pager
}

func (p *DescribeManagedPrefixListsPaginator) CurrentPage() *DescribeManagedPrefixListsOutput {
	return p.Pager.CurrentPage().(*DescribeManagedPrefixListsOutput)
}

// DescribeManagedPrefixListsResponse is the response type for the
// DescribeManagedPrefixLists API operation.
type DescribeManagedPrefixListsResponse struct {
	*DescribeManagedPrefixListsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeManagedPrefixLists request.
func (r *DescribeManagedPrefixListsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
