// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetManagedPrefixListAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the prefix list.
	//
	// PrefixListId is a required field
	PrefixListId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetManagedPrefixListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetManagedPrefixListAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetManagedPrefixListAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if s.PrefixListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrefixListId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetManagedPrefixListAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the associations.
	PrefixListAssociations []PrefixListAssociation `locationName:"prefixListAssociationSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s GetManagedPrefixListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetManagedPrefixListAssociations = "GetManagedPrefixListAssociations"

// GetManagedPrefixListAssociationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Gets information about the resources that are associated with the specified
// managed prefix list.
//
//    // Example sending a request using GetManagedPrefixListAssociationsRequest.
//    req := client.GetManagedPrefixListAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetManagedPrefixListAssociations
func (c *Client) GetManagedPrefixListAssociationsRequest(input *GetManagedPrefixListAssociationsInput) GetManagedPrefixListAssociationsRequest {
	op := &aws.Operation{
		Name:       opGetManagedPrefixListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetManagedPrefixListAssociationsInput{}
	}

	req := c.newRequest(op, input, &GetManagedPrefixListAssociationsOutput{})

	return GetManagedPrefixListAssociationsRequest{Request: req, Input: input, Copy: c.GetManagedPrefixListAssociationsRequest}
}

// GetManagedPrefixListAssociationsRequest is the request type for the
// GetManagedPrefixListAssociations API operation.
type GetManagedPrefixListAssociationsRequest struct {
	*aws.Request
	Input *GetManagedPrefixListAssociationsInput
	Copy  func(*GetManagedPrefixListAssociationsInput) GetManagedPrefixListAssociationsRequest
}

// Send marshals and sends the GetManagedPrefixListAssociations API request.
func (r GetManagedPrefixListAssociationsRequest) Send(ctx context.Context) (*GetManagedPrefixListAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetManagedPrefixListAssociationsResponse{
		GetManagedPrefixListAssociationsOutput: r.Request.Data.(*GetManagedPrefixListAssociationsOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetManagedPrefixListAssociationsRequestPaginator returns a paginator for GetManagedPrefixListAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetManagedPrefixListAssociationsRequest(input)
//   p := ec2.NewGetManagedPrefixListAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetManagedPrefixListAssociationsPaginator(req GetManagedPrefixListAssociationsRequest) GetManagedPrefixListAssociationsPaginator {
	return GetManagedPrefixListAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetManagedPrefixListAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetManagedPrefixListAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetManagedPrefixListAssociationsPaginator struct {
	aws.Pager
}

func (p *GetManagedPrefixListAssociationsPaginator) CurrentPage() *GetManagedPrefixListAssociationsOutput {
	return p.Pager.CurrentPage().(*GetManagedPrefixListAssociationsOutput)
}

// GetManagedPrefixListAssociationsResponse is the response type for the
// GetManagedPrefixListAssociations API operation.
type GetManagedPrefixListAssociationsResponse struct {
	*GetManagedPrefixListAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetManagedPrefixListAssociations request.
func (r *GetManagedPrefixListAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
