// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTransitGatewayMulticastDomainAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. The possible values are:
	//
	//    * resource-id - The ID of the resource.
	//
	//    * resource-type - The type of resource. The valid value is: vpc.
	//
	//    * state - The state of the subnet association. Valid values are associated
	//    | associating | disassociated | disassociating.
	//
	//    * subnet-id - The ID of the subnet.
	//
	//    * transit-gateway-attachment-id - The id of the transit gateway attachment.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s GetTransitGatewayMulticastDomainAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTransitGatewayMulticastDomainAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTransitGatewayMulticastDomainAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTransitGatewayMulticastDomainAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the multicast domain associations.
	MulticastDomainAssociations []TransitGatewayMulticastDomainAssociation `locationName:"multicastDomainAssociations" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetTransitGatewayMulticastDomainAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTransitGatewayMulticastDomainAssociations = "GetTransitGatewayMulticastDomainAssociations"

// GetTransitGatewayMulticastDomainAssociationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Gets information about the associations for the transit gateway multicast
// domain.
//
//    // Example sending a request using GetTransitGatewayMulticastDomainAssociationsRequest.
//    req := client.GetTransitGatewayMulticastDomainAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetTransitGatewayMulticastDomainAssociations
func (c *Client) GetTransitGatewayMulticastDomainAssociationsRequest(input *GetTransitGatewayMulticastDomainAssociationsInput) GetTransitGatewayMulticastDomainAssociationsRequest {
	op := &aws.Operation{
		Name:       opGetTransitGatewayMulticastDomainAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTransitGatewayMulticastDomainAssociationsInput{}
	}

	req := c.newRequest(op, input, &GetTransitGatewayMulticastDomainAssociationsOutput{})

	return GetTransitGatewayMulticastDomainAssociationsRequest{Request: req, Input: input, Copy: c.GetTransitGatewayMulticastDomainAssociationsRequest}
}

// GetTransitGatewayMulticastDomainAssociationsRequest is the request type for the
// GetTransitGatewayMulticastDomainAssociations API operation.
type GetTransitGatewayMulticastDomainAssociationsRequest struct {
	*aws.Request
	Input *GetTransitGatewayMulticastDomainAssociationsInput
	Copy  func(*GetTransitGatewayMulticastDomainAssociationsInput) GetTransitGatewayMulticastDomainAssociationsRequest
}

// Send marshals and sends the GetTransitGatewayMulticastDomainAssociations API request.
func (r GetTransitGatewayMulticastDomainAssociationsRequest) Send(ctx context.Context) (*GetTransitGatewayMulticastDomainAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTransitGatewayMulticastDomainAssociationsResponse{
		GetTransitGatewayMulticastDomainAssociationsOutput: r.Request.Data.(*GetTransitGatewayMulticastDomainAssociationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTransitGatewayMulticastDomainAssociationsRequestPaginator returns a paginator for GetTransitGatewayMulticastDomainAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTransitGatewayMulticastDomainAssociationsRequest(input)
//   p := ec2.NewGetTransitGatewayMulticastDomainAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTransitGatewayMulticastDomainAssociationsPaginator(req GetTransitGatewayMulticastDomainAssociationsRequest) GetTransitGatewayMulticastDomainAssociationsPaginator {
	return GetTransitGatewayMulticastDomainAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTransitGatewayMulticastDomainAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTransitGatewayMulticastDomainAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTransitGatewayMulticastDomainAssociationsPaginator struct {
	aws.Pager
}

func (p *GetTransitGatewayMulticastDomainAssociationsPaginator) CurrentPage() *GetTransitGatewayMulticastDomainAssociationsOutput {
	return p.Pager.CurrentPage().(*GetTransitGatewayMulticastDomainAssociationsOutput)
}

// GetTransitGatewayMulticastDomainAssociationsResponse is the response type for the
// GetTransitGatewayMulticastDomainAssociations API operation.
type GetTransitGatewayMulticastDomainAssociationsResponse struct {
	*GetTransitGatewayMulticastDomainAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTransitGatewayMulticastDomainAssociations request.
func (r *GetTransitGatewayMulticastDomainAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
