// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type SendDiagnosticInterruptInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendDiagnosticInterruptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendDiagnosticInterruptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendDiagnosticInterruptInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SendDiagnosticInterruptOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendDiagnosticInterruptOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendDiagnosticInterrupt = "SendDiagnosticInterrupt"

// SendDiagnosticInterruptRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger
// a kernel panic (on Linux instances), or a blue screen/stop error (on Windows
// instances). For instances based on Intel and AMD processors, the interrupt
// is received as a non-maskable interrupt (NMI).
//
// In general, the operating system crashes and reboots when a kernel panic
// or stop error is triggered. The operating system can also be configured to
// perform diagnostic tasks, such as generating a memory dump file, loading
// a secondary kernel, or obtaining a call trace.
//
// Before sending a diagnostic interrupt to your instance, ensure that its operating
// system is configured to perform the required diagnostic tasks.
//
// For more information about configuring your operating system to generate
// a crash dump when a kernel panic or stop error occurs, see Send a diagnostic
// interrupt (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html)
// (Linux instances) or Send a Diagnostic Interrupt (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/diagnostic-interrupt.html)
// (Windows instances).
//
//    // Example sending a request using SendDiagnosticInterruptRequest.
//    req := client.SendDiagnosticInterruptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SendDiagnosticInterrupt
func (c *Client) SendDiagnosticInterruptRequest(input *SendDiagnosticInterruptInput) SendDiagnosticInterruptRequest {
	op := &aws.Operation{
		Name:       opSendDiagnosticInterrupt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendDiagnosticInterruptInput{}
	}

	req := c.newRequest(op, input, &SendDiagnosticInterruptOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SendDiagnosticInterruptRequest{Request: req, Input: input, Copy: c.SendDiagnosticInterruptRequest}
}

// SendDiagnosticInterruptRequest is the request type for the
// SendDiagnosticInterrupt API operation.
type SendDiagnosticInterruptRequest struct {
	*aws.Request
	Input *SendDiagnosticInterruptInput
	Copy  func(*SendDiagnosticInterruptInput) SendDiagnosticInterruptRequest
}

// Send marshals and sends the SendDiagnosticInterrupt API request.
func (r SendDiagnosticInterruptRequest) Send(ctx context.Context) (*SendDiagnosticInterruptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendDiagnosticInterruptResponse{
		SendDiagnosticInterruptOutput: r.Request.Data.(*SendDiagnosticInterruptOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendDiagnosticInterruptResponse is the response type for the
// SendDiagnosticInterrupt API operation.
type SendDiagnosticInterruptResponse struct {
	*SendDiagnosticInterruptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendDiagnosticInterrupt request.
func (r *SendDiagnosticInterruptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
