// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The AMI type for your node group. GPU instance types should use the AL2_x86_64_GPU
	// AMI type, which uses the Amazon EKS-optimized Linux AMI with GPU support.
	// Non-GPU instances should use the AL2_x86_64 AMI type, which uses the Amazon
	// EKS-optimized Linux AMI.
	AmiType AMITypes `locationName:"amiType" type:"string" enum:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to create the node group in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The root device disk size (in GiB) for your node group instances. The default
	// disk size is 20 GiB.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The instance type to use for your node group. Currently, you can specify
	// a single instance type for a node group. The default value for this parameter
	// is t3.medium. If you choose a GPU instance type, be sure to specify the AL2_x86_64_GPU
	// with the amiType parameter.
	InstanceTypes []string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels to be applied to the nodes in the node group when they
	// are created.
	Labels map[string]string `locationName:"labels" type:"map"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with your node
	// group. The Amazon EKS worker node kubelet daemon makes calls to AWS APIs
	// on your behalf. Worker nodes receive permissions for these API calls through
	// an IAM instance profile and associated policies. Before you can launch worker
	// nodes and register them into a cluster, you must create an IAM role for those
	// worker nodes to use when they are launched. For more information, see Amazon
	// EKS Worker Node IAM Role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	// in the Amazon EKS User Guide .
	//
	// NodeRole is a required field
	NodeRole *string `locationName:"nodeRole" type:"string" required:"true"`

	// The unique name to give your node group.
	//
	// NodegroupName is a required field
	NodegroupName *string `locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS-optimized AMI to use with your node group.
	// By default, the latest available AMI version for the node group's current
	// Kubernetes version is used. For more information, see Amazon EKS-Optimized
	// Linux AMI Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The remote access (SSH) configuration to use with your node group.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is created
	// for your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The subnets to use for the Auto Scaling group that is created for your node
	// group. These subnets must have the tag key kubernetes.io/cluster/CLUSTER_NAME
	// with a value of shared, where CLUSTER_NAME is replaced with the name of your
	// cluster.
	//
	// Subnets is a required field
	Subnets []string `locationName:"subnets" type:"list" required:"true"`

	// The metadata to apply to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes version to use for your managed nodes. By default, the Kubernetes
	// version of the cluster is used, and this is the only accepted specified value.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s CreateNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodegroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateNodegroupInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.NodeRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeRole"))
	}

	if s.NodegroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodegroupName"))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateNodegroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.AmiType) > 0 {
		v := s.AmiType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "amiType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DiskSize != nil {
		v := *s.DiskSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "diskSize", protocol.Int64Value(v), metadata)
	}
	if s.InstanceTypes != nil {
		v := s.InstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "labels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.NodeRole != nil {
		v := *s.NodeRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodeRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupName != nil {
		v := *s.NodegroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodegroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReleaseVersion != nil {
		v := *s.ReleaseVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "releaseVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RemoteAccess != nil {
		v := s.RemoteAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteAccess", v, metadata)
	}
	if s.ScalingConfig != nil {
		v := s.ScalingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scalingConfig", v, metadata)
	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation
func (s CreateNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateNodegroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Nodegroup != nil {
		v := s.Nodegroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodegroup", v, metadata)
	}
	return nil
}

const opCreateNodegroup = "CreateNodegroup"

// CreateNodegroupRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Creates a managed worker node group for an Amazon EKS cluster. You can only
// create a node group for your cluster that is equal to the current Kubernetes
// version for the cluster. All node groups are created with the latest AMI
// release version for the respective minor Kubernetes version of the cluster.
//
// An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
// associated Amazon EC2 instances that are managed by AWS for an Amazon EKS
// cluster. Each node group uses a version of the Amazon EKS-optimized Amazon
// Linux 2 AMI. For more information, see Managed Node Groups (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html)
// in the Amazon EKS User Guide.
//
//    // Example sending a request using CreateNodegroupRequest.
//    req := client.CreateNodegroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *Client) CreateNodegroupRequest(input *CreateNodegroupInput) CreateNodegroupRequest {
	op := &aws.Operation{
		Name:       opCreateNodegroup,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups",
	}

	if input == nil {
		input = &CreateNodegroupInput{}
	}

	req := c.newRequest(op, input, &CreateNodegroupOutput{})

	return CreateNodegroupRequest{Request: req, Input: input, Copy: c.CreateNodegroupRequest}
}

// CreateNodegroupRequest is the request type for the
// CreateNodegroup API operation.
type CreateNodegroupRequest struct {
	*aws.Request
	Input *CreateNodegroupInput
	Copy  func(*CreateNodegroupInput) CreateNodegroupRequest
}

// Send marshals and sends the CreateNodegroup API request.
func (r CreateNodegroupRequest) Send(ctx context.Context) (*CreateNodegroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateNodegroupResponse{
		CreateNodegroupOutput: r.Request.Data.(*CreateNodegroupOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateNodegroupResponse is the response type for the
// CreateNodegroup API operation.
type CreateNodegroupResponse struct {
	*CreateNodegroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateNodegroup request.
func (r *CreateNodegroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
