// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
)

// WaitUntilEnvironmentExists uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilEnvironmentExists(ctx context.Context, input *DescribeEnvironmentsInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilEnvironmentExists",
		MaxAttempts: 20,
		Delay:       aws.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Ready",
			},
			{
				State:   aws.RetryWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Launching",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilEnvironmentTerminated uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilEnvironmentTerminated(ctx context.Context, input *DescribeEnvironmentsInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilEnvironmentTerminated",
		MaxAttempts: 20,
		Delay:       aws.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Terminated",
			},
			{
				State:   aws.RetryWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Terminating",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilEnvironmentUpdated uses the Elastic Beanstalk API operation
// DescribeEnvironments to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilEnvironmentUpdated(ctx context.Context, input *DescribeEnvironmentsInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilEnvironmentUpdated",
		MaxAttempts: 20,
		Delay:       aws.ConstantWaiterDelay(20 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Ready",
			},
			{
				State:   aws.RetryWaiterState,
				Matcher: aws.PathAllWaiterMatch, Argument: "Environments[].Status",
				Expected: "Updating",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}
