// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DeregisterInstancesFromLoadBalancer.
type DeregisterInstancesFromLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	//
	// Instances is a required field
	Instances []Instance `type:"list" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstancesFromLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterInstancesFromLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterInstancesFromLoadBalancerInput"}

	if s.Instances == nil {
		invalidParams.Add(aws.NewErrParamRequired("Instances"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeregisterInstancesFromLoadBalancer.
type DeregisterInstancesFromLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The remaining instances registered with the load balancer.
	Instances []Instance `type:"list"`
}

// String returns the string representation
func (s DeregisterInstancesFromLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterInstancesFromLoadBalancer = "DeregisterInstancesFromLoadBalancer"

// DeregisterInstancesFromLoadBalancerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deregisters the specified instances from the specified load balancer. After
// the instance is deregistered, it no longer receives traffic from the load
// balancer.
//
// You can use DescribeLoadBalancers to verify that the instance is deregistered
// from the load balancer.
//
// For more information, see Register or De-Register EC2 Instances (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using DeregisterInstancesFromLoadBalancerRequest.
//    req := client.DeregisterInstancesFromLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeregisterInstancesFromLoadBalancer
func (c *Client) DeregisterInstancesFromLoadBalancerRequest(input *DeregisterInstancesFromLoadBalancerInput) DeregisterInstancesFromLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opDeregisterInstancesFromLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstancesFromLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &DeregisterInstancesFromLoadBalancerOutput{})

	return DeregisterInstancesFromLoadBalancerRequest{Request: req, Input: input, Copy: c.DeregisterInstancesFromLoadBalancerRequest}
}

// DeregisterInstancesFromLoadBalancerRequest is the request type for the
// DeregisterInstancesFromLoadBalancer API operation.
type DeregisterInstancesFromLoadBalancerRequest struct {
	*aws.Request
	Input *DeregisterInstancesFromLoadBalancerInput
	Copy  func(*DeregisterInstancesFromLoadBalancerInput) DeregisterInstancesFromLoadBalancerRequest
}

// Send marshals and sends the DeregisterInstancesFromLoadBalancer API request.
func (r DeregisterInstancesFromLoadBalancerRequest) Send(ctx context.Context) (*DeregisterInstancesFromLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterInstancesFromLoadBalancerResponse{
		DeregisterInstancesFromLoadBalancerOutput: r.Request.Data.(*DeregisterInstancesFromLoadBalancerOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterInstancesFromLoadBalancerResponse is the response type for the
// DeregisterInstancesFromLoadBalancer API operation.
type DeregisterInstancesFromLoadBalancerResponse struct {
	*DeregisterInstancesFromLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterInstancesFromLoadBalancer request.
func (r *DeregisterInstancesFromLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
