// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteListenerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListenerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteListenerInput"}

	if s.ListenerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteListenerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteListener = "DeleteListener"

// DeleteListenerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deletes the specified listener.
//
// Alternatively, your listener is deleted when you delete the load balancer
// to which it is attached, using DeleteLoadBalancer.
//
//    // Example sending a request using DeleteListenerRequest.
//    req := client.DeleteListenerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener
func (c *Client) DeleteListenerRequest(input *DeleteListenerInput) DeleteListenerRequest {
	op := &aws.Operation{
		Name:       opDeleteListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteListenerInput{}
	}

	req := c.newRequest(op, input, &DeleteListenerOutput{})

	return DeleteListenerRequest{Request: req, Input: input, Copy: c.DeleteListenerRequest}
}

// DeleteListenerRequest is the request type for the
// DeleteListener API operation.
type DeleteListenerRequest struct {
	*aws.Request
	Input *DeleteListenerInput
	Copy  func(*DeleteListenerInput) DeleteListenerRequest
}

// Send marshals and sends the DeleteListener API request.
func (r DeleteListenerRequest) Send(ctx context.Context) (*DeleteListenerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteListenerResponse{
		DeleteListenerOutput: r.Request.Data.(*DeleteListenerOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteListenerResponse is the response type for the
// DeleteListener API operation.
type DeleteListenerResponse struct {
	*DeleteListenerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteListener request.
func (r *DeleteListenerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
