// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the CreateOutboundCrossClusterSearchConnection
// operation.
type CreateOutboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure"`

	// Specifies the connection alias that will be used by the customer for this
	// connection.
	//
	// ConnectionAlias is a required field
	ConnectionAlias *string `type:"string" required:"true"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	//
	// DestinationDomainInfo is a required field
	DestinationDomainInfo *DomainInformation `type:"structure" required:"true"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	//
	// SourceDomainInfo is a required field
	SourceDomainInfo *DomainInformation `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateOutboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateOutboundCrossClusterSearchConnectionInput"}

	if s.ConnectionAlias == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionAlias"))
	}

	if s.DestinationDomainInfo == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationDomainInfo"))
	}

	if s.SourceDomainInfo == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceDomainInfo"))
	}
	if s.DestinationDomainInfo != nil {
		if err := s.DestinationDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("DestinationDomainInfo", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceDomainInfo != nil {
		if err := s.SourceDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("SourceDomainInfo", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateOutboundCrossClusterSearchConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConnectionAlias != nil {
		v := *s.ConnectionAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationDomainInfo != nil {
		v := s.DestinationDomainInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DestinationDomainInfo", v, metadata)
	}
	if s.SourceDomainInfo != nil {
		v := s.SourceDomainInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceDomainInfo", v, metadata)
	}
	return nil
}

// The result of a CreateOutboundCrossClusterSearchConnection request. Contains
// the details of the newly created cross-cluster search connection.
type CreateOutboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the connection alias provided during the create connection request.
	ConnectionAlias *string `type:"string"`

	// Specifies the OutboundCrossClusterSearchConnectionStatus for the newly created
	// connection.
	ConnectionStatus *OutboundCrossClusterSearchConnectionStatus `type:"structure"`

	// Unique id for the created outbound connection, which is used for subsequent
	// operations on connection.
	CrossClusterSearchConnectionId *string `type:"string"`

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation `type:"structure"`

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation `type:"structure"`
}

// String returns the string representation
func (s CreateOutboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateOutboundCrossClusterSearchConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionAlias != nil {
		v := *s.ConnectionAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionStatus != nil {
		v := s.ConnectionStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ConnectionStatus", v, metadata)
	}
	if s.CrossClusterSearchConnectionId != nil {
		v := *s.CrossClusterSearchConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CrossClusterSearchConnectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationDomainInfo != nil {
		v := s.DestinationDomainInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DestinationDomainInfo", v, metadata)
	}
	if s.SourceDomainInfo != nil {
		v := s.SourceDomainInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceDomainInfo", v, metadata)
	}
	return nil
}

const opCreateOutboundCrossClusterSearchConnection = "CreateOutboundCrossClusterSearchConnection"

// CreateOutboundCrossClusterSearchConnectionRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Creates a new cross-cluster search connection from a source domain to a destination
// domain.
//
//    // Example sending a request using CreateOutboundCrossClusterSearchConnectionRequest.
//    req := client.CreateOutboundCrossClusterSearchConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateOutboundCrossClusterSearchConnectionRequest(input *CreateOutboundCrossClusterSearchConnectionInput) CreateOutboundCrossClusterSearchConnectionRequest {
	op := &aws.Operation{
		Name:       opCreateOutboundCrossClusterSearchConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection",
	}

	if input == nil {
		input = &CreateOutboundCrossClusterSearchConnectionInput{}
	}

	req := c.newRequest(op, input, &CreateOutboundCrossClusterSearchConnectionOutput{})

	return CreateOutboundCrossClusterSearchConnectionRequest{Request: req, Input: input, Copy: c.CreateOutboundCrossClusterSearchConnectionRequest}
}

// CreateOutboundCrossClusterSearchConnectionRequest is the request type for the
// CreateOutboundCrossClusterSearchConnection API operation.
type CreateOutboundCrossClusterSearchConnectionRequest struct {
	*aws.Request
	Input *CreateOutboundCrossClusterSearchConnectionInput
	Copy  func(*CreateOutboundCrossClusterSearchConnectionInput) CreateOutboundCrossClusterSearchConnectionRequest
}

// Send marshals and sends the CreateOutboundCrossClusterSearchConnection API request.
func (r CreateOutboundCrossClusterSearchConnectionRequest) Send(ctx context.Context) (*CreateOutboundCrossClusterSearchConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateOutboundCrossClusterSearchConnectionResponse{
		CreateOutboundCrossClusterSearchConnectionOutput: r.Request.Data.(*CreateOutboundCrossClusterSearchConnectionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateOutboundCrossClusterSearchConnectionResponse is the response type for the
// CreateOutboundCrossClusterSearchConnection API operation.
type CreateOutboundCrossClusterSearchConnectionResponse struct {
	*CreateOutboundCrossClusterSearchConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateOutboundCrossClusterSearchConnection request.
func (r *CreateOutboundCrossClusterSearchConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
