// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DeleteElasticsearchDomain operation.
// Specifies the name of the Elasticsearch domain that you want to delete.
type DeleteElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain that you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteElasticsearchDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteElasticsearchDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteElasticsearchDomainInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a DeleteElasticsearchDomain request. Contains the status of
// the pending deletion, or no status if the domain and all of its resources
// have been deleted.
type DeleteElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the Elasticsearch domain being deleted.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteElasticsearchDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainStatus != nil {
		v := s.DomainStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainStatus", v, metadata)
	}
	return nil
}

const opDeleteElasticsearchDomain = "DeleteElasticsearchDomain"

// DeleteElasticsearchDomainRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Permanently deletes the specified Elasticsearch domain and all of its data.
// Once a domain is deleted, it cannot be recovered.
//
//    // Example sending a request using DeleteElasticsearchDomainRequest.
//    req := client.DeleteElasticsearchDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteElasticsearchDomainRequest(input *DeleteElasticsearchDomainInput) DeleteElasticsearchDomainRequest {
	op := &aws.Operation{
		Name:       opDeleteElasticsearchDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteElasticsearchDomainInput{}
	}

	req := c.newRequest(op, input, &DeleteElasticsearchDomainOutput{})

	return DeleteElasticsearchDomainRequest{Request: req, Input: input, Copy: c.DeleteElasticsearchDomainRequest}
}

// DeleteElasticsearchDomainRequest is the request type for the
// DeleteElasticsearchDomain API operation.
type DeleteElasticsearchDomainRequest struct {
	*aws.Request
	Input *DeleteElasticsearchDomainInput
	Copy  func(*DeleteElasticsearchDomainInput) DeleteElasticsearchDomainRequest
}

// Send marshals and sends the DeleteElasticsearchDomain API request.
func (r DeleteElasticsearchDomainRequest) Send(ctx context.Context) (*DeleteElasticsearchDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteElasticsearchDomainResponse{
		DeleteElasticsearchDomainOutput: r.Request.Data.(*DeleteElasticsearchDomainOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteElasticsearchDomainResponse is the response type for the
// DeleteElasticsearchDomain API operation.
type DeleteElasticsearchDomainResponse struct {
	*DeleteElasticsearchDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteElasticsearchDomain request.
func (r *DeleteElasticsearchDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
