// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DeleteInboundCrossClusterSearchConnection
// operation.
type DeleteInboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure"`

	// The id of the inbound connection that you want to permanently delete.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInboundCrossClusterSearchConnectionInput"}

	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteInboundCrossClusterSearchConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CrossClusterSearchConnectionId != nil {
		v := *s.CrossClusterSearchConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a DeleteInboundCrossClusterSearchConnection operation. Contains
// details of deleted inbound connection.
type DeleteInboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnection of deleted inbound connection.
	CrossClusterSearchConnection *InboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation
func (s DeleteInboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteInboundCrossClusterSearchConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CrossClusterSearchConnection != nil {
		v := s.CrossClusterSearchConnection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CrossClusterSearchConnection", v, metadata)
	}
	return nil
}

const opDeleteInboundCrossClusterSearchConnection = "DeleteInboundCrossClusterSearchConnection"

// DeleteInboundCrossClusterSearchConnectionRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Allows the destination domain owner to delete an existing inbound cross-cluster
// search connection.
//
//    // Example sending a request using DeleteInboundCrossClusterSearchConnectionRequest.
//    req := client.DeleteInboundCrossClusterSearchConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteInboundCrossClusterSearchConnectionRequest(input *DeleteInboundCrossClusterSearchConnectionInput) DeleteInboundCrossClusterSearchConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteInboundCrossClusterSearchConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteInboundCrossClusterSearchConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteInboundCrossClusterSearchConnectionOutput{})

	return DeleteInboundCrossClusterSearchConnectionRequest{Request: req, Input: input, Copy: c.DeleteInboundCrossClusterSearchConnectionRequest}
}

// DeleteInboundCrossClusterSearchConnectionRequest is the request type for the
// DeleteInboundCrossClusterSearchConnection API operation.
type DeleteInboundCrossClusterSearchConnectionRequest struct {
	*aws.Request
	Input *DeleteInboundCrossClusterSearchConnectionInput
	Copy  func(*DeleteInboundCrossClusterSearchConnectionInput) DeleteInboundCrossClusterSearchConnectionRequest
}

// Send marshals and sends the DeleteInboundCrossClusterSearchConnection API request.
func (r DeleteInboundCrossClusterSearchConnectionRequest) Send(ctx context.Context) (*DeleteInboundCrossClusterSearchConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInboundCrossClusterSearchConnectionResponse{
		DeleteInboundCrossClusterSearchConnectionOutput: r.Request.Data.(*DeleteInboundCrossClusterSearchConnectionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInboundCrossClusterSearchConnectionResponse is the response type for the
// DeleteInboundCrossClusterSearchConnection API operation.
type DeleteInboundCrossClusterSearchConnectionResponse struct {
	*DeleteInboundCrossClusterSearchConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInboundCrossClusterSearchConnection request.
func (r *DeleteInboundCrossClusterSearchConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
