// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetBlockPublicAccessConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetBlockPublicAccessConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

type GetBlockPublicAccessConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A configuration for Amazon EMR block public access. The configuration applies
	// to all clusters created in your account for the current Region. The configuration
	// specifies whether block public access is enabled. If block public access
	// is enabled, security groups associated with the cluster cannot have rules
	// that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port
	// is specified as an exception using PermittedPublicSecurityGroupRuleRanges
	// in the BlockPublicAccessConfiguration. By default, Port 22 (SSH) is an exception,
	// and public access is allowed on this port. You can change this by updating
	// the block public access configuration to remove the exception.
	//
	// For accounts that created clusters in a Region before November 25, 2019,
	// block public access is disabled by default in that Region. To use this feature,
	// you must manually enable and configure it. For accounts that did not create
	// an EMR cluster in a Region before this date, block public access is enabled
	// by default in that Region.
	//
	// BlockPublicAccessConfiguration is a required field
	BlockPublicAccessConfiguration *BlockPublicAccessConfiguration `type:"structure" required:"true"`

	// Properties that describe the AWS principal that created the BlockPublicAccessConfiguration
	// using the PutBlockPublicAccessConfiguration action as well as the date and
	// time that the configuration was created. Each time a configuration for block
	// public access is updated, Amazon EMR updates this metadata.
	//
	// BlockPublicAccessConfigurationMetadata is a required field
	BlockPublicAccessConfigurationMetadata *BlockPublicAccessConfigurationMetadata `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBlockPublicAccessConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetBlockPublicAccessConfiguration = "GetBlockPublicAccessConfiguration"

// GetBlockPublicAccessConfigurationRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Returns the Amazon EMR block public access configuration for your AWS account
// in the current Region. For more information see Configure Block Public Access
// for Amazon EMR (https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
// in the Amazon EMR Management Guide.
//
//    // Example sending a request using GetBlockPublicAccessConfigurationRequest.
//    req := client.GetBlockPublicAccessConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration
func (c *Client) GetBlockPublicAccessConfigurationRequest(input *GetBlockPublicAccessConfigurationInput) GetBlockPublicAccessConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetBlockPublicAccessConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlockPublicAccessConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetBlockPublicAccessConfigurationOutput{})

	return GetBlockPublicAccessConfigurationRequest{Request: req, Input: input, Copy: c.GetBlockPublicAccessConfigurationRequest}
}

// GetBlockPublicAccessConfigurationRequest is the request type for the
// GetBlockPublicAccessConfiguration API operation.
type GetBlockPublicAccessConfigurationRequest struct {
	*aws.Request
	Input *GetBlockPublicAccessConfigurationInput
	Copy  func(*GetBlockPublicAccessConfigurationInput) GetBlockPublicAccessConfigurationRequest
}

// Send marshals and sends the GetBlockPublicAccessConfiguration API request.
func (r GetBlockPublicAccessConfigurationRequest) Send(ctx context.Context) (*GetBlockPublicAccessConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBlockPublicAccessConfigurationResponse{
		GetBlockPublicAccessConfigurationOutput: r.Request.Data.(*GetBlockPublicAccessConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBlockPublicAccessConfigurationResponse is the response type for the
// GetBlockPublicAccessConfiguration API operation.
type GetBlockPublicAccessConfigurationResponse struct {
	*GetBlockPublicAccessConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBlockPublicAccessConfiguration request.
func (r *GetBlockPublicAccessConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
