// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RemoveManagedScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the cluster from which the managed scaling policy will
	// be removed.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveManagedScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveManagedScalingPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveManagedScalingPolicyInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveManagedScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveManagedScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveManagedScalingPolicy = "RemoveManagedScalingPolicy"

// RemoveManagedScalingPolicyRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Removes a managed scaling policy from a specified EMR cluster.
//
//    // Example sending a request using RemoveManagedScalingPolicyRequest.
//    req := client.RemoveManagedScalingPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy
func (c *Client) RemoveManagedScalingPolicyRequest(input *RemoveManagedScalingPolicyInput) RemoveManagedScalingPolicyRequest {
	op := &aws.Operation{
		Name:       opRemoveManagedScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveManagedScalingPolicyInput{}
	}

	req := c.newRequest(op, input, &RemoveManagedScalingPolicyOutput{})

	return RemoveManagedScalingPolicyRequest{Request: req, Input: input, Copy: c.RemoveManagedScalingPolicyRequest}
}

// RemoveManagedScalingPolicyRequest is the request type for the
// RemoveManagedScalingPolicy API operation.
type RemoveManagedScalingPolicyRequest struct {
	*aws.Request
	Input *RemoveManagedScalingPolicyInput
	Copy  func(*RemoveManagedScalingPolicyInput) RemoveManagedScalingPolicyRequest
}

// Send marshals and sends the RemoveManagedScalingPolicy API request.
func (r RemoveManagedScalingPolicyRequest) Send(ctx context.Context) (*RemoveManagedScalingPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveManagedScalingPolicyResponse{
		RemoveManagedScalingPolicyOutput: r.Request.Data.(*RemoveManagedScalingPolicyOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveManagedScalingPolicyResponse is the response type for the
// RemoveManagedScalingPolicy API operation.
type RemoveManagedScalingPolicyResponse struct {
	*RemoveManagedScalingPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveManagedScalingPolicy request.
func (r *RemoveManagedScalingPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
