// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteProtocolsListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the protocols list that you want to delete. You can retrieve this
	// ID from PutProtocolsList, ListProtocolsLists, and GetProtocolsLost.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProtocolsListInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProtocolsListInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProtocolsListInput"}

	if s.ListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteProtocolsListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProtocolsListOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteProtocolsList = "DeleteProtocolsList"

// DeleteProtocolsListRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Permanently deletes an AWS Firewall Manager protocols list.
//
//    // Example sending a request using DeleteProtocolsListRequest.
//    req := client.DeleteProtocolsListRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteProtocolsList
func (c *Client) DeleteProtocolsListRequest(input *DeleteProtocolsListInput) DeleteProtocolsListRequest {
	op := &aws.Operation{
		Name:       opDeleteProtocolsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProtocolsListInput{}
	}

	req := c.newRequest(op, input, &DeleteProtocolsListOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteProtocolsListRequest{Request: req, Input: input, Copy: c.DeleteProtocolsListRequest}
}

// DeleteProtocolsListRequest is the request type for the
// DeleteProtocolsList API operation.
type DeleteProtocolsListRequest struct {
	*aws.Request
	Input *DeleteProtocolsListInput
	Copy  func(*DeleteProtocolsListInput) DeleteProtocolsListRequest
}

// Send marshals and sends the DeleteProtocolsList API request.
func (r DeleteProtocolsListRequest) Send(ctx context.Context) (*DeleteProtocolsListResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProtocolsListResponse{
		DeleteProtocolsListOutput: r.Request.Data.(*DeleteProtocolsListOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProtocolsListResponse is the response type for the
// DeleteProtocolsList API operation.
type DeleteProtocolsListResponse struct {
	*DeleteProtocolsListOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProtocolsList request.
func (r *DeleteProtocolsListResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
