// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetProtocolsListInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the list to retrieve is a default list owned by AWS Firewall
	// Manager.
	DefaultList *bool `type:"boolean"`

	// The ID of the AWS Firewall Manager protocols list that you want the details
	// for.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProtocolsListInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProtocolsListInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetProtocolsListInput"}

	if s.ListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetProtocolsListOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified AWS Firewall Manager protocols list.
	ProtocolsList *ProtocolsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified protocols list.
	ProtocolsListArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetProtocolsListOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetProtocolsList = "GetProtocolsList"

// GetProtocolsListRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Returns information about the specified AWS Firewall Manager protocols list.
//
//    // Example sending a request using GetProtocolsListRequest.
//    req := client.GetProtocolsListRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtocolsList
func (c *Client) GetProtocolsListRequest(input *GetProtocolsListInput) GetProtocolsListRequest {
	op := &aws.Operation{
		Name:       opGetProtocolsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProtocolsListInput{}
	}

	req := c.newRequest(op, input, &GetProtocolsListOutput{})

	return GetProtocolsListRequest{Request: req, Input: input, Copy: c.GetProtocolsListRequest}
}

// GetProtocolsListRequest is the request type for the
// GetProtocolsList API operation.
type GetProtocolsListRequest struct {
	*aws.Request
	Input *GetProtocolsListInput
	Copy  func(*GetProtocolsListInput) GetProtocolsListRequest
}

// Send marshals and sends the GetProtocolsList API request.
func (r GetProtocolsListRequest) Send(ctx context.Context) (*GetProtocolsListResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetProtocolsListResponse{
		GetProtocolsListOutput: r.Request.Data.(*GetProtocolsListOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetProtocolsListResponse is the response type for the
// GetProtocolsList API operation.
type GetProtocolsListResponse struct {
	*GetProtocolsListOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetProtocolsList request.
func (r *GetProtocolsListResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
