// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutAppsListInput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager applications list to be created.
	//
	// AppsList is a required field
	AppsList *AppsListData `type:"structure" required:"true"`

	// The tags associated with the resource.
	TagList []Tag `type:"list"`
}

// String returns the string representation
func (s PutAppsListInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppsListInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAppsListInput"}

	if s.AppsList == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppsList"))
	}
	if s.AppsList != nil {
		if err := s.AppsList.Validate(); err != nil {
			invalidParams.AddNested("AppsList", err.(aws.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutAppsListOutput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager applications list.
	AppsList *AppsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the applications list.
	AppsListArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutAppsListOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAppsList = "PutAppsList"

// PutAppsListRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Creates an AWS Firewall Manager applications list.
//
//    // Example sending a request using PutAppsListRequest.
//    req := client.PutAppsListRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList
func (c *Client) PutAppsListRequest(input *PutAppsListInput) PutAppsListRequest {
	op := &aws.Operation{
		Name:       opPutAppsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAppsListInput{}
	}

	req := c.newRequest(op, input, &PutAppsListOutput{})

	return PutAppsListRequest{Request: req, Input: input, Copy: c.PutAppsListRequest}
}

// PutAppsListRequest is the request type for the
// PutAppsList API operation.
type PutAppsListRequest struct {
	*aws.Request
	Input *PutAppsListInput
	Copy  func(*PutAppsListInput) PutAppsListRequest
}

// Send marshals and sends the PutAppsList API request.
func (r PutAppsListRequest) Send(ctx context.Context) (*PutAppsListResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAppsListResponse{
		PutAppsListOutput: r.Request.Data.(*PutAppsListOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAppsListResponse is the response type for the
// PutAppsList API operation.
type PutAppsListResponse struct {
	*PutAppsListOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAppsList request.
func (r *PutAppsListResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
