// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An individual AWS Firewall Manager application.
type App struct {
	_ struct{} `type:"structure"`

	// The application's name.
	//
	// AppName is a required field
	AppName *string `min:"1" type:"string" required:"true"`

	// The application's port number, for example 80.
	//
	// Port is a required field
	Port *int64 `type:"long" required:"true"`

	// The IP protocol name or number. The name can be one of tcp, udp, or icmp.
	// For information on possible numbers, see Protocol Numbers (https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
	//
	// Protocol is a required field
	Protocol *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *App) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "App"}

	if s.AppName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppName"))
	}
	if s.AppName != nil && len(*s.AppName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppName", 1))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}

	if s.Protocol == nil {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}
	if s.Protocol != nil && len(*s.Protocol) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Protocol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An AWS Firewall Manager applications list.
type AppsListData struct {
	_ struct{} `type:"structure"`

	// An array of applications in the AWS Firewall Manager applications list.
	//
	// AppsList is a required field
	AppsList []App `type:"list" required:"true"`

	// The time that the AWS Firewall Manager applications list was created.
	CreateTime *time.Time `type:"timestamp"`

	// The time that the AWS Firewall Manager applications list was last updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The ID of the AWS Firewall Manager applications list.
	ListId *string `min:"36" type:"string"`

	// The name of the AWS Firewall Manager applications list.
	//
	// ListName is a required field
	ListName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the list. When you update the list,
	// the update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string `min:"1" type:"string"`

	// A map of previous version numbers to their corresponding App object arrays.
	PreviousAppsList map[string][]App `type:"map"`
}

// String returns the string representation
func (s AppsListData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppsListData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AppsListData"}

	if s.AppsList == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppsList"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ListId", 36))
	}

	if s.ListName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListName"))
	}
	if s.ListName != nil && len(*s.ListName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ListName", 1))
	}
	if s.ListUpdateToken != nil && len(*s.ListUpdateToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ListUpdateToken", 1))
	}
	if s.AppsList != nil {
		for i, v := range s.AppsList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AppsList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details of the AWS Firewall Manager applications list.
type AppsListDataSummary struct {
	_ struct{} `type:"structure"`

	// An array of App objects in the AWS Firewall Manager applications list.
	AppsList []App `type:"list"`

	// The Amazon Resource Name (ARN) of the applications list.
	ListArn *string `min:"1" type:"string"`

	// The ID of the applications list.
	ListId *string `min:"36" type:"string"`

	// The name of the applications list.
	ListName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AppsListDataSummary) String() string {
	return awsutil.Prettify(s)
}

// Violations for an EC2 instance resource.
type AwsEc2InstanceViolation struct {
	_ struct{} `type:"structure"`

	// Violations for network interfaces associated with the EC2 instance.
	AwsEc2NetworkInterfaceViolations []AwsEc2NetworkInterfaceViolation `type:"list"`

	// The resource ID of the EC2 instance.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceViolation) String() string {
	return awsutil.Prettify(s)
}

// Violations for network interfaces associated with an EC2 instance.
type AwsEc2NetworkInterfaceViolation struct {
	_ struct{} `type:"structure"`

	// List of security groups that violate the rules specified in the master security
	// group of the AWS Firewall Manager policy.
	ViolatingSecurityGroups []string `type:"list"`

	// The resource ID of the network interface.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceViolation) String() string {
	return awsutil.Prettify(s)
}

// Details of the rule violation in a security group when compared to the master
// security group of the AWS Firewall Manager policy.
type AwsVPCSecurityGroupViolation struct {
	_ struct{} `type:"structure"`

	// List of rules specified in the security group of the AWS Firewall Manager
	// policy that partially match the ViolationTarget rule.
	PartialMatches []PartialMatch `type:"list"`

	// Remediation options for the rule specified in the ViolationTarget.
	PossibleSecurityGroupRemediationActions []SecurityGroupRemediationAction `type:"list"`

	// The security group rule that is being evaluated.
	ViolationTarget *string `type:"string"`

	// A description of the security group that violates the policy.
	ViolationTargetDescription *string `type:"string"`
}

// String returns the string representation
func (s AwsVPCSecurityGroupViolation) String() string {
	return awsutil.Prettify(s)
}

// Details of the resource that is not protected by the policy.
type ComplianceViolator struct {
	_ struct{} `type:"structure"`

	// The resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The resource type. This is in the format shown in the AWS Resource Types
	// Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer or AWS::CloudFront::Distribution.
	ResourceType *string `min:"1" type:"string"`

	// The reason that the resource is not protected by the policy.
	ViolationReason ViolationReason `type:"string" enum:"true"`
}

// String returns the string representation
func (s ComplianceViolator) String() string {
	return awsutil.Prettify(s)
}

// Describes the compliance status for the account. An account is considered
// noncompliant if it includes resources that are not protected by the specified
// policy or that don't comply with the policy.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Describes an AWS account's compliance with the AWS Firewall Manager policy.
	ComplianceStatus PolicyComplianceStatusType `type:"string" enum:"true"`

	// Indicates that over 100 resources are noncompliant with the AWS Firewall
	// Manager policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// The number of resources that are noncompliant with the specified policy.
	// For AWS WAF and Shield Advanced policies, a resource is considered noncompliant
	// if it is not associated with the policy. For security group policies, a resource
	// is considered noncompliant if it doesn't comply with the rules of the policy
	// and remediation is disabled or not possible.
	ViolatorCount *int64 `type:"long"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// The reference rule that partially matches the ViolationTarget rule and violation
// reason.
type PartialMatch struct {
	_ struct{} `type:"structure"`

	// The reference rule from the master security group of the AWS Firewall Manager
	// policy.
	Reference *string `type:"string"`

	// The violation reason.
	TargetViolationReasons []string `type:"list"`
}

// String returns the string representation
func (s PartialMatch) String() string {
	return awsutil.Prettify(s)
}

// An AWS Firewall Manager policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS account IDs and AWS Organizations organizational units
	// (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying
	// all accounts in the OU and in any of its child OUs, including any child OUs
	// and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap, AWS Firewall Manager applies the policy to all accounts specified
	// by the IncludeMap, and does not evaluate any ExcludeMap specifications. If
	// you do not specify an IncludeMap, then Firewall Manager applies the policy
	// to all accounts except for those specified by the ExcludeMap.
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//    * Specify account IDs by setting the key to ACCOUNT. For example, the
	//    following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]}.
	//
	//    * Specify OUs by setting the key to ORG_UNIT. For example, the following
	//    is a valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]}.
	//
	//    * Specify accounts and OUs together in a single map, separated with a
	//    comma. For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//    “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}.
	ExcludeMap map[string][]string `type:"map"`

	// If set to True, resources with the tags that are specified in the ResourceTag
	// array are not in scope of the policy. If set to False, and the ResourceTag
	// array is not null, only resources with the specified tags are in scope of
	// the policy.
	//
	// ExcludeResourceTags is a required field
	ExcludeResourceTags *bool `type:"boolean" required:"true"`

	// Specifies the AWS account IDs and AWS Organizations organizational units
	// (OUs) to include in the policy. Specifying an OU is the equivalent of specifying
	// all accounts in the OU and in any of its child OUs, including any child OUs
	// and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap, AWS Firewall Manager applies the policy to all accounts specified
	// by the IncludeMap, and does not evaluate any ExcludeMap specifications. If
	// you do not specify an IncludeMap, then Firewall Manager applies the policy
	// to all accounts except for those specified by the ExcludeMap.
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//    * Specify account IDs by setting the key to ACCOUNT. For example, the
	//    following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]}.
	//
	//    * Specify OUs by setting the key to ORG_UNIT. For example, the following
	//    is a valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]}.
	//
	//    * Specify accounts and OUs together in a single map, separated with a
	//    comma. For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//    “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}.
	IncludeMap map[string][]string `type:"map"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the AWS Firewall Manager policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the policy. When issuing a PutPolicy
	// request, the PolicyUpdateToken in the request must match the PolicyUpdateToken
	// of the current policy version. To get the PolicyUpdateToken of the current
	// policy version, use a GetPolicy request.
	PolicyUpdateToken *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	//
	// RemediationEnabled is a required field
	RemediationEnabled *bool `type:"boolean" required:"true"`

	// An array of ResourceTag objects.
	ResourceTags []ResourceTag `type:"list"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For AWS WAF and Shield Advanced, examples include AWS::ElasticLoadBalancingV2::LoadBalancer
	// and AWS::CloudFront::Distribution. For a security group common policy, valid
	// values are AWS::EC2::NetworkInterface and AWS::EC2::Instance. For a security
	// group content audit policy, valid values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface,
	// and AWS::EC2::Instance. For a security group usage audit policy, the value
	// is AWS::EC2::SecurityGroup.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// An array of ResourceType.
	ResourceTypeList []string `type:"list"`

	// Details about the security service that is being used to protect the resources.
	//
	// SecurityServicePolicyData is a required field
	SecurityServicePolicyData *SecurityServicePolicyData `type:"structure" required:"true"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Policy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Policy"}

	if s.ExcludeResourceTags == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExcludeResourceTags"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyId", 36))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyUpdateToken != nil && len(*s.PolicyUpdateToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyUpdateToken", 1))
	}

	if s.RemediationEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("RemediationEnabled"))
	}

	if s.ResourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceType", 1))
	}

	if s.SecurityServicePolicyData == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityServicePolicyData"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SecurityServicePolicyData != nil {
		if err := s.SecurityServicePolicyData.Validate(); err != nil {
			invalidParams.AddNested("SecurityServicePolicyData", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the noncompliant resources in a member account for a specific AWS
// Firewall Manager policy. A maximum of 100 entries are displayed. If more
// than 100 resources are noncompliant, EvaluationLimitExceeded is set to True.
type PolicyComplianceDetail struct {
	_ struct{} `type:"structure"`

	// Indicates if over 100 resources are noncompliant with the AWS Firewall Manager
	// policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// A timestamp that indicates when the returned information should be considered
	// out of date.
	ExpiredAt *time.Time `type:"timestamp"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be noncompliant. The details include the name
	// of the dependent service and the error message received that indicates the
	// problem with the service.
	IssueInfoMap map[string]string `type:"map"`

	// The AWS account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`

	// An array of resources that aren't protected by the AWS WAF or Shield Advanced
	// policy or that aren't in compliance with the security group policy.
	Violators []ComplianceViolator `type:"list"`
}

// String returns the string representation
func (s PolicyComplianceDetail) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether the account is compliant with the specified policy. An
// account is considered noncompliant if it includes resources that are not
// protected by the policy, for AWS WAF and Shield Advanced policies, or that
// are noncompliant with the policy, for security group policies.
type PolicyComplianceStatus struct {
	_ struct{} `type:"structure"`

	// An array of EvaluationResult objects.
	EvaluationResults []EvaluationResult `type:"list"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be noncompliant. The details include the name
	// of the dependent service and the error message received that indicates the
	// problem with the service.
	IssueInfoMap map[string]string `type:"map"`

	// Timestamp of the last update to the EvaluationResult objects.
	LastUpdated *time.Time `type:"timestamp"`

	// The member account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the AWS Firewall Manager policy.
	PolicyName *string `min:"1" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyComplianceStatus) String() string {
	return awsutil.Prettify(s)
}

// Details of the AWS Firewall Manager policy.
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`

	// The ID of the specified policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the specified policy.
	PolicyName *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	RemediationEnabled *bool `type:"boolean"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For AWS WAF and Shield Advanced, examples include AWS::ElasticLoadBalancingV2::LoadBalancer
	// and AWS::CloudFront::Distribution. For a security group common policy, valid
	// values are AWS::EC2::NetworkInterface and AWS::EC2::Instance. For a security
	// group content audit policy, valid values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface,
	// and AWS::EC2::Instance. For a security group usage audit policy, the value
	// is AWS::EC2::SecurityGroup.
	ResourceType *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an AWS WAF policy, a Shield Advanced
	// policy, or a security group policy.
	SecurityServiceType SecurityServiceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// An AWS Firewall Manager protocols list.
type ProtocolsListData struct {
	_ struct{} `type:"structure"`

	// The time that the AWS Firewall Manager protocols list was created.
	CreateTime *time.Time `type:"timestamp"`

	// The time that the AWS Firewall Manager protocols list was last updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The ID of the AWS Firewall Manager protocols list.
	ListId *string `min:"36" type:"string"`

	// The name of the AWS Firewall Manager protocols list.
	//
	// ListName is a required field
	ListName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the list. When you update the list,
	// the update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string `min:"1" type:"string"`

	// A map of previous version numbers to their corresponding protocol arrays.
	PreviousProtocolsList map[string][]string `type:"map"`

	// An array of protocols in the AWS Firewall Manager protocols list.
	//
	// ProtocolsList is a required field
	ProtocolsList []string `type:"list" required:"true"`
}

// String returns the string representation
func (s ProtocolsListData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtocolsListData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProtocolsListData"}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ListId", 36))
	}

	if s.ListName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListName"))
	}
	if s.ListName != nil && len(*s.ListName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ListName", 1))
	}
	if s.ListUpdateToken != nil && len(*s.ListUpdateToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ListUpdateToken", 1))
	}

	if s.ProtocolsList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProtocolsList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details of the AWS Firewall Manager protocols list.
type ProtocolsListDataSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified protocols list.
	ListArn *string `min:"1" type:"string"`

	// The ID of the specified protocols list.
	ListId *string `min:"36" type:"string"`

	// The name of the specified protocols list.
	ListName *string `min:"1" type:"string"`

	// An array of protocols in the AWS Firewall Manager protocols list.
	ProtocolsList []string `type:"list"`
}

// String returns the string representation
func (s ProtocolsListDataSummary) String() string {
	return awsutil.Prettify(s)
}

// The resource tags that AWS Firewall Manager uses to determine if a particular
// resource should be included or excluded from the AWS Firewall Manager policy.
// Tags enable you to categorize your AWS resources in different ways, for example,
// by purpose, owner, or environment. Each tag consists of a key and an optional
// value. Firewall Manager combines the tags with "AND" so that, if you add
// more than one tag to a policy scope, a resource must have all the specified
// tags to be included or excluded. For more information, see Working with Tag
// Editor (https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html).
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The resource tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The resource tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceTag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Violation detail based on resource type.
type ResourceViolation struct {
	_ struct{} `type:"structure"`

	// Violation details for an EC2 instance.
	AwsEc2InstanceViolation *AwsEc2InstanceViolation `type:"structure"`

	// Violation details for network interface.
	AwsEc2NetworkInterfaceViolation *AwsEc2NetworkInterfaceViolation `type:"structure"`

	// Violation details for security groups.
	AwsVPCSecurityGroupViolation *AwsVPCSecurityGroupViolation `type:"structure"`
}

// String returns the string representation
func (s ResourceViolation) String() string {
	return awsutil.Prettify(s)
}

// Remediation option for the rule specified in the ViolationTarget.
type SecurityGroupRemediationAction struct {
	_ struct{} `type:"structure"`

	// Brief description of the action that will be performed.
	Description *string `type:"string"`

	// Indicates if the current action is the default action.
	IsDefaultAction *bool `type:"boolean"`

	// The remediation action that will be performed.
	RemediationActionType RemediationActionType `type:"string" enum:"true"`

	// The final state of the rule specified in the ViolationTarget after it is
	// remediated.
	RemediationResult *SecurityGroupRuleDescription `type:"structure"`
}

// String returns the string representation
func (s SecurityGroupRemediationAction) String() string {
	return awsutil.Prettify(s)
}

// Describes a set of permissions for a security group rule.
type SecurityGroupRuleDescription struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. A value of -1 indicates all ICMP/ICMPv6 types.
	FromPort *int64 `type:"long"`

	// The IPv4 ranges for the security group rule.
	IPV4Range *string `type:"string"`

	// The IPv6 ranges for the security group rule.
	IPV6Range *string `type:"string"`

	// The ID of the prefix list for the security group rule.
	PrefixListId *string `min:"1" type:"string"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	Protocol *string `type:"string"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code. A value of -1 indicates all ICMP/ICMPv6 codes.
	ToPort *int64 `type:"long"`
}

// String returns the string representation
func (s SecurityGroupRuleDescription) String() string {
	return awsutil.Prettify(s)
}

// Details about the security service that is being used to protect the resources.
type SecurityServicePolicyData struct {
	_ struct{} `type:"structure"`

	// Details about the service that are specific to the service type, in JSON
	// format. For service type SHIELD_ADVANCED, this is an empty string.
	//
	//    * Example: WAFV2 "ManagedServiceData": "{\"type\":\"WAFV2\",\"defaultAction\":{\"type\":\"ALLOW\"},\"preProcessRuleGroups\":[{\"managedRuleGroupIdentifier\":null,\"ruleGroupArn\":\"rulegrouparn\",\"overrideAction\":{\"type\":\"COUNT\"},\"excludeRules\":[{\"name\":\"EntityName\"}],\"ruleGroupType\":\"RuleGroup\"}],\"postProcessRuleGroups\":[{\"managedRuleGroupIdentifier\":{\"managedRuleGroupName\":\"AWSManagedRulesAdminProtectionRuleSet\",\"vendorName\":\"AWS\"},\"ruleGroupArn\":\"rulegrouparn\",\"overrideAction\":{\"type\":\"NONE\"},\"excludeRules\":[],\"ruleGroupType\":\"ManagedRuleGroup\"}],\"overrideCustomerWebACLAssociation\":false}"
	//
	//    * Example: WAF Classic "ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\":
	//    [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\"
	//    : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}
	//
	//    * Example: SECURITY_GROUPS_COMMON "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,
	//    \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}
	//
	//    * Example: SECURITY_GROUPS_CONTENT_AUDIT "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"
	//    sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}
	//    The security group action for content audit can be ALLOW or DENY. For
	//    ALLOW, all in-scope security group rules must be within the allowed range
	//    of the policy's security group rules. For DENY, all in-scope security
	//    group rules must not contain a value or a range that matches a rule value
	//    or range in the policy security group.
	//
	//    * Example: SECURITY_GROUPS_USAGE_AUDIT "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou
	//    rceType":"AWS::EC2::SecurityGroup"}
	ManagedServiceData *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an AWS WAF policy, a Shield Advanced
	// policy, or a security group policy. For security group policies, Firewall
	// Manager supports one security group for each common policy and for each content
	// audit policy. This is an adjustable limit that you can increase by contacting
	// AWS Support.
	//
	// Type is a required field
	Type SecurityServiceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SecurityServicePolicyData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityServicePolicyData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SecurityServicePolicyData"}
	if s.ManagedServiceData != nil && len(*s.ManagedServiceData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ManagedServiceData", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A collection of key:value pairs associated with an AWS resource. The key:value
// pair can be anything you define. Typically, the tag key represents a category
// (such as "environment") and the tag value represents a specific value within
// that category (such as "test," "development," or "production"). You can add
// up to 50 tags to each AWS resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Violations for a resource based on the specified AWS Firewall Manager policy
// and AWS account.
type ViolationDetail struct {
	_ struct{} `type:"structure"`

	// The AWS account that the violation details were requested for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the AWS Firewall Manager policy that the violation details were
	// requested for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// Brief description for the requested resource.
	ResourceDescription *string `type:"string"`

	// The resource ID that the violation details were requested for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ResourceTag objects associated with the resource.
	ResourceTags []Tag `type:"list"`

	// The resource type that the violation details were requested for.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// List of violations for the requested resource.
	//
	// ResourceViolations is a required field
	ResourceViolations []ResourceViolation `type:"list" required:"true"`
}

// String returns the string representation
func (s ViolationDetail) String() string {
	return awsutil.Prettify(s)
}
