// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the detector under which you want to create a new version.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The Amazon Sagemaker model endpoints to include in the detector version.
	ExternalModelEndpoints []string `locationName:"externalModelEndpoints" type:"list"`

	// The model versions to include in the detector version.
	ModelVersions []ModelVersion `locationName:"modelVersions" type:"list"`

	// The rule execution mode for the rules included in the detector version.
	//
	// You can define and edit the rule mode at the detector version level, when
	// it is in draft status.
	//
	// If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules.
	//
	// The default behavior is FIRST_MATCHED.
	RuleExecutionMode RuleExecutionMode `locationName:"ruleExecutionMode" type:"string" enum:"true"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []Rule `locationName:"rules" type:"list" required:"true"`

	// A collection of key and value pairs.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the created version's parent detector.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The ID for the created detector.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The status of the detector version.
	Status DetectorVersionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDetectorVersion = "CreateDetectorVersion"

// CreateDetectorVersionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates a detector version. The detector version starts in a DRAFT status.
//
//    // Example sending a request using CreateDetectorVersionRequest.
//    req := client.CreateDetectorVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *Client) CreateDetectorVersionRequest(input *CreateDetectorVersionInput) CreateDetectorVersionRequest {
	op := &aws.Operation{
		Name:       opCreateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDetectorVersionInput{}
	}

	req := c.newRequest(op, input, &CreateDetectorVersionOutput{})

	return CreateDetectorVersionRequest{Request: req, Input: input, Copy: c.CreateDetectorVersionRequest}
}

// CreateDetectorVersionRequest is the request type for the
// CreateDetectorVersion API operation.
type CreateDetectorVersionRequest struct {
	*aws.Request
	Input *CreateDetectorVersionInput
	Copy  func(*CreateDetectorVersionInput) CreateDetectorVersionRequest
}

// Send marshals and sends the CreateDetectorVersion API request.
func (r CreateDetectorVersionRequest) Send(ctx context.Context) (*CreateDetectorVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDetectorVersionResponse{
		CreateDetectorVersionOutput: r.Request.Data.(*CreateDetectorVersionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDetectorVersionResponse is the response type for the
// CreateDetectorVersion API operation.
type CreateDetectorVersionResponse struct {
	*CreateDetectorVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDetectorVersion request.
func (r *CreateDetectorVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
