// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// The array of models.
	Models []Model `locationName:"models" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetModels = "GetModels"

// GetModelsRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets one or more models. Gets all models for the AWS account if no model
// type and no model id provided. Gets all models for the AWS account and model
// type, if the model type is specified but model id is not provided. Gets a
// specific model if (model type, model id) tuple is specified.
//
// This is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 1 and 10. To get the next page results, provide the pagination
// token from the response as part of your request. A null pagination token
// fetches the records from the beginning.
//
//    // Example sending a request using GetModelsRequest.
//    req := client.GetModelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *Client) GetModelsRequest(input *GetModelsInput) GetModelsRequest {
	op := &aws.Operation{
		Name:       opGetModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	req := c.newRequest(op, input, &GetModelsOutput{})

	return GetModelsRequest{Request: req, Input: input, Copy: c.GetModelsRequest}
}

// GetModelsRequest is the request type for the
// GetModels API operation.
type GetModelsRequest struct {
	*aws.Request
	Input *GetModelsInput
	Copy  func(*GetModelsInput) GetModelsRequest
}

// Send marshals and sends the GetModels API request.
func (r GetModelsRequest) Send(ctx context.Context) (*GetModelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetModelsResponse{
		GetModelsOutput: r.Request.Data.(*GetModelsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetModelsRequestPaginator returns a paginator for GetModels.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetModelsRequest(input)
//   p := frauddetector.NewGetModelsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetModelsPaginator(req GetModelsRequest) GetModelsPaginator {
	return GetModelsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetModelsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetModelsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetModelsPaginator struct {
	aws.Pager
}

func (p *GetModelsPaginator) CurrentPage() *GetModelsOutput {
	return p.Pager.CurrentPage().(*GetModelsOutput)
}

// GetModelsResponse is the response type for the
// GetModels API operation.
type GetModelsResponse struct {
	*GetModelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetModels request.
func (r *GetModelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
