// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutEntityTypeInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the entity type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutEntityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEntityTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEntityTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutEntityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEntityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutEntityType = "PutEntityType"

// PutEntityTypeRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates or updates an entity type. An entity represents who is performing
// the event. As part of a fraud prediction, you pass the entity ID to indicate
// the specific entity who performed the event. An entity type classifies the
// entity. Example classifications include customer, merchant, or account.
//
//    // Example sending a request using PutEntityTypeRequest.
//    req := client.PutEntityTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType
func (c *Client) PutEntityTypeRequest(input *PutEntityTypeInput) PutEntityTypeRequest {
	op := &aws.Operation{
		Name:       opPutEntityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEntityTypeInput{}
	}

	req := c.newRequest(op, input, &PutEntityTypeOutput{})

	return PutEntityTypeRequest{Request: req, Input: input, Copy: c.PutEntityTypeRequest}
}

// PutEntityTypeRequest is the request type for the
// PutEntityType API operation.
type PutEntityTypeRequest struct {
	*aws.Request
	Input *PutEntityTypeInput
	Copy  func(*PutEntityTypeInput) PutEntityTypeRequest
}

// Send marshals and sends the PutEntityType API request.
func (r PutEntityTypeRequest) Send(ctx context.Context) (*PutEntityTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEntityTypeResponse{
		PutEntityTypeOutput: r.Request.Data.(*PutEntityTypeOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEntityTypeResponse is the response type for the
// PutEntityType API operation.
type PutEntityTypeResponse struct {
	*PutEntityTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEntityType request.
func (r *PutEntityTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
