// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Cancels a data repository task.
type CancelDataRepositoryTaskInput struct {
	_ struct{} `type:"structure"`

	// Specifies the data repository task to cancel.
	//
	// TaskId is a required field
	TaskId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelDataRepositoryTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelDataRepositoryTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelDataRepositoryTaskInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelDataRepositoryTaskOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle status of the data repository task, as follows:
	//
	//    * PENDING - Amazon FSx has not started the task.
	//
	//    * EXECUTING - Amazon FSx is processing the task.
	//
	//    * FAILED - Amazon FSx was not able to complete the task. For example,
	//    there may be files the task failed to process. The DataRepositoryTaskFailureDetails
	//    property provides more information about task failures.
	//
	//    * SUCCEEDED - FSx completed the task successfully.
	//
	//    * CANCELED - Amazon FSx canceled the task and it did not complete.
	//
	//    * CANCELING - FSx is in process of canceling the task.
	Lifecycle DataRepositoryTaskLifecycle `type:"string" enum:"true"`

	// The ID of the task being canceled.
	TaskId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CancelDataRepositoryTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelDataRepositoryTask = "CancelDataRepositoryTask"

// CancelDataRepositoryTaskRequest returns a request value for making API operation for
// Amazon FSx.
//
// Cancels an existing Amazon FSx for Lustre data repository task if that task
// is in either the PENDING or EXECUTING state. When you cancel a task, Amazon
// FSx does the following.
//
//    * Any files that FSx has already exported are not reverted.
//
//    * FSx continues to export any files that are "in-flight" when the cancel
//    operation is received.
//
//    * FSx does not export any files that have not yet been exported.
//
//    // Example sending a request using CancelDataRepositoryTaskRequest.
//    req := client.CancelDataRepositoryTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CancelDataRepositoryTask
func (c *Client) CancelDataRepositoryTaskRequest(input *CancelDataRepositoryTaskInput) CancelDataRepositoryTaskRequest {
	op := &aws.Operation{
		Name:       opCancelDataRepositoryTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelDataRepositoryTaskInput{}
	}

	req := c.newRequest(op, input, &CancelDataRepositoryTaskOutput{})

	return CancelDataRepositoryTaskRequest{Request: req, Input: input, Copy: c.CancelDataRepositoryTaskRequest}
}

// CancelDataRepositoryTaskRequest is the request type for the
// CancelDataRepositoryTask API operation.
type CancelDataRepositoryTaskRequest struct {
	*aws.Request
	Input *CancelDataRepositoryTaskInput
	Copy  func(*CancelDataRepositoryTaskInput) CancelDataRepositoryTaskRequest
}

// Send marshals and sends the CancelDataRepositoryTask API request.
func (r CancelDataRepositoryTaskRequest) Send(ctx context.Context) (*CancelDataRepositoryTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelDataRepositoryTaskResponse{
		CancelDataRepositoryTaskOutput: r.Request.Data.(*CancelDataRepositoryTaskOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelDataRepositoryTaskResponse is the response type for the
// CancelDataRepositoryTask API operation.
type CancelDataRepositoryTaskResponse struct {
	*CancelDataRepositoryTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelDataRepositoryTask request.
func (r *CancelDataRepositoryTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
