// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDataRepositoryTasksInput struct {
	_ struct{} `type:"structure"`

	// (Optional) You can use filters to narrow the DescribeDataRepositoryTasks
	// response to include just tasks for specific file systems, or tasks in a specific
	// lifecycle state.
	Filters []DataRepositoryTaskFilter `type:"list"`

	// The maximum number of resources to return in the response. This value must
	// be an integer greater than zero.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing
	// the request, where the previous NextToken value left off.
	NextToken *string `min:"1" type:"string"`

	// (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
	TaskIds []string `type:"list"`
}

// String returns the string representation
func (s DescribeDataRepositoryTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataRepositoryTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDataRepositoryTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDataRepositoryTasksOutput struct {
	_ struct{} `type:"structure"`

	// The collection of data repository task descriptions returned.
	DataRepositoryTasks []DataRepositoryTask `type:"list"`

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing
	// the request, where the previous NextToken value left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDataRepositoryTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDataRepositoryTasks = "DescribeDataRepositoryTasks"

// DescribeDataRepositoryTasksRequest returns a request value for making API operation for
// Amazon FSx.
//
// Returns the description of specific Amazon FSx for Lustre data repository
// tasks, if one or more TaskIds values are provided in the request, or if filters
// are used in the request. You can use filters to narrow the response to include
// just tasks for specific file systems, or tasks in a specific lifecycle state.
// Otherwise, it returns all data repository tasks owned by your AWS account
// in the AWS Region of the endpoint that you're calling.
//
// When retrieving all tasks, you can paginate the response by using the optional
// MaxResults parameter to limit the number of tasks returned in a response.
// If more tasks remain, Amazon FSx returns a NextToken value in the response.
// In this case, send a later request with the NextToken request parameter set
// to the value of NextToken from the last response.
//
//    // Example sending a request using DescribeDataRepositoryTasksRequest.
//    req := client.DescribeDataRepositoryTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks
func (c *Client) DescribeDataRepositoryTasksRequest(input *DescribeDataRepositoryTasksInput) DescribeDataRepositoryTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeDataRepositoryTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDataRepositoryTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeDataRepositoryTasksOutput{})

	return DescribeDataRepositoryTasksRequest{Request: req, Input: input, Copy: c.DescribeDataRepositoryTasksRequest}
}

// DescribeDataRepositoryTasksRequest is the request type for the
// DescribeDataRepositoryTasks API operation.
type DescribeDataRepositoryTasksRequest struct {
	*aws.Request
	Input *DescribeDataRepositoryTasksInput
	Copy  func(*DescribeDataRepositoryTasksInput) DescribeDataRepositoryTasksRequest
}

// Send marshals and sends the DescribeDataRepositoryTasks API request.
func (r DescribeDataRepositoryTasksRequest) Send(ctx context.Context) (*DescribeDataRepositoryTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDataRepositoryTasksResponse{
		DescribeDataRepositoryTasksOutput: r.Request.Data.(*DescribeDataRepositoryTasksOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeDataRepositoryTasksRequestPaginator returns a paginator for DescribeDataRepositoryTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeDataRepositoryTasksRequest(input)
//   p := fsx.NewDescribeDataRepositoryTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeDataRepositoryTasksPaginator(req DescribeDataRepositoryTasksRequest) DescribeDataRepositoryTasksPaginator {
	return DescribeDataRepositoryTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeDataRepositoryTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeDataRepositoryTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeDataRepositoryTasksPaginator struct {
	aws.Pager
}

func (p *DescribeDataRepositoryTasksPaginator) CurrentPage() *DescribeDataRepositoryTasksOutput {
	return p.Pager.CurrentPage().(*DescribeDataRepositoryTasksOutput)
}

// DescribeDataRepositoryTasksResponse is the response type for the
// DescribeDataRepositoryTasks API operation.
type DescribeDataRepositoryTasksResponse struct {
	*DescribeDataRepositoryTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDataRepositoryTasks request.
func (r *DescribeDataRepositoryTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
