// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request object for ListTagsForResource operation.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of tags to return in the response (integer). This parameter
	// value must be greater than 0. The number of items that Amazon FSx returns
	// is the minimum of the MaxResults parameter specified in the request and the
	// service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Opaque pagination token returned from a previous ListTagsForResource operation
	// (String). If a token present, the action continues the list from where the
	// returning call left off.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the Amazon FSx resource that will have its tags listed.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for ListTagsForResource operation.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// This is present if there are more tags than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the tags.
	NextToken *string `min:"1" type:"string"`

	// A list of tags on the resource.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest returns a request value for making API operation for
// Amazon FSx.
//
// Lists tags for an Amazon FSx file systems and backups in the case of Amazon
// FSx for Windows File Server.
//
// When retrieving all tags, you can optionally specify the MaxResults parameter
// to limit the number of tags in a response. If more tags remain, Amazon FSx
// returns a NextToken value in the response. In this case, send a later request
// with the NextToken request parameter set to the value of NextToken from the
// last response.
//
// This action is used in an iterative process to retrieve a list of your tags.
// ListTagsForResource is called first without a NextTokenvalue. Then the action
// continues to be called with the NextToken parameter set to the value of the
// last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of tags returned in the response of one ListTagsForResource
//    call and the order of tags returned across the responses of a multi-call
//    iteration is unspecified.
//
//    // Example sending a request using ListTagsForResourceRequest.
//    req := client.ListTagsForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource
func (c *Client) ListTagsForResourceRequest(input *ListTagsForResourceInput) ListTagsForResourceRequest {
	op := &aws.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req := c.newRequest(op, input, &ListTagsForResourceOutput{})

	return ListTagsForResourceRequest{Request: req, Input: input, Copy: c.ListTagsForResourceRequest}
}

// ListTagsForResourceRequest is the request type for the
// ListTagsForResource API operation.
type ListTagsForResourceRequest struct {
	*aws.Request
	Input *ListTagsForResourceInput
	Copy  func(*ListTagsForResourceInput) ListTagsForResourceRequest
}

// Send marshals and sends the ListTagsForResource API request.
func (r ListTagsForResourceRequest) Send(ctx context.Context) (*ListTagsForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTagsForResourceResponse{
		ListTagsForResourceOutput: r.Request.Data.(*ListTagsForResourceOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTagsForResourceResponse is the response type for the
// ListTagsForResource API operation.
type ListTagsForResourceResponse struct {
	*ListTagsForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTagsForResource request.
func (r *ListTagsForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
