// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeGameServerInput struct {
	_ struct{} `type:"structure"`

	// An identifier for the game server group where the game server is running.
	// Use either the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// The identifier for the game server to be retrieved.
	//
	// GameServerId is a required field
	GameServerId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGameServerInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if s.GameServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerId"))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeGameServerOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game server resource.
	GameServer *GameServer `type:"structure"`
}

// String returns the string representation
func (s DescribeGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGameServer = "DescribeGameServer"

// DescribeGameServerRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Retrieves information for a game server resource. Information includes the
// game server statuses, health check info, and the instance the game server
// is running on.
//
// To retrieve game server information, specify the game server ID. If successful,
// the requested game server object is returned.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * RegisterGameServer
//
//    * ListGameServers
//
//    * ClaimGameServer
//
//    * DescribeGameServer
//
//    * UpdateGameServer
//
//    * DeregisterGameServer
//
//    // Example sending a request using DescribeGameServerRequest.
//    req := client.DescribeGameServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer
func (c *Client) DescribeGameServerRequest(input *DescribeGameServerInput) DescribeGameServerRequest {
	op := &aws.Operation{
		Name:       opDescribeGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameServerInput{}
	}

	req := c.newRequest(op, input, &DescribeGameServerOutput{})

	return DescribeGameServerRequest{Request: req, Input: input, Copy: c.DescribeGameServerRequest}
}

// DescribeGameServerRequest is the request type for the
// DescribeGameServer API operation.
type DescribeGameServerRequest struct {
	*aws.Request
	Input *DescribeGameServerInput
	Copy  func(*DescribeGameServerInput) DescribeGameServerRequest
}

// Send marshals and sends the DescribeGameServer API request.
func (r DescribeGameServerRequest) Send(ctx context.Context) (*DescribeGameServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGameServerResponse{
		DescribeGameServerOutput: r.Request.Data.(*DescribeGameServerOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGameServerResponse is the response type for the
// DescribeGameServer API operation.
type DescribeGameServerResponse struct {
	*DescribeGameServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGameServer request.
func (r *DescribeGameServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
