// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type ResolveAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias that you want to retrieve a fleet ID for.
	// You can use either the alias ID or ARN value.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResolveAliasInput"}

	if s.AliasId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type ResolveAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html))
	// associated with the GameLift fleet resource that this alias points to.
	FleetArn *string `type:"string"`

	// The fleet identifier that the alias is pointing to.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s ResolveAliasOutput) String() string {
	return awsutil.Prettify(s)
}

const opResolveAlias = "ResolveAlias"

// ResolveAliasRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves the fleet ID that an alias is currently pointing to.
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
//    // Example sending a request using ResolveAliasRequest.
//    req := client.ResolveAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *Client) ResolveAliasRequest(input *ResolveAliasInput) ResolveAliasRequest {
	op := &aws.Operation{
		Name:       opResolveAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveAliasInput{}
	}

	req := c.newRequest(op, input, &ResolveAliasOutput{})

	return ResolveAliasRequest{Request: req, Input: input, Copy: c.ResolveAliasRequest}
}

// ResolveAliasRequest is the request type for the
// ResolveAlias API operation.
type ResolveAliasRequest struct {
	*aws.Request
	Input *ResolveAliasInput
	Copy  func(*ResolveAliasInput) ResolveAliasRequest
}

// Send marshals and sends the ResolveAlias API request.
func (r ResolveAliasRequest) Send(ctx context.Context) (*ResolveAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResolveAliasResponse{
		ResolveAliasOutput: r.Request.Data.(*ResolveAliasOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResolveAliasResponse is the response type for the
// ResolveAlias API operation.
type ResolveAliasResponse struct {
	*ResolveAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResolveAlias request.
func (r *ResolveAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
