// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ResumeGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the game server group to resume activity on. Use
	// either the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// The action to resume for this game server group.
	//
	// ResumeActions is a required field
	ResumeActions []GameServerGroupAction `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResumeGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResumeGameServerGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResumeGameServerGroupInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if s.ResumeActions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResumeActions"))
	}
	if s.ResumeActions != nil && len(s.ResumeActions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResumeActions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ResumeGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the game server group resource, with the SuspendedActions
	// property updated to reflect the resumed activity.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation
func (s ResumeGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opResumeGameServerGroup = "ResumeGameServerGroup"

// ResumeGameServerGroupRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Reinstates activity on a game server group after it has been suspended. A
// game server group may be suspended by calling SuspendGameServerGroup, or
// it may have been involuntarily suspended due to a configuration problem.
// You can manually resume activity on the group once the configuration problem
// has been resolved. Refer to the game server group status and status reason
// for more information on why group activity is suspended.
//
// To resume activity, specify a game server group ARN and the type of activity
// to be resumed.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * CreateGameServerGroup
//
//    * ListGameServerGroups
//
//    * DescribeGameServerGroup
//
//    * UpdateGameServerGroup
//
//    * DeleteGameServerGroup
//
//    * ResumeGameServerGroup
//
//    * SuspendGameServerGroup
//
//    // Example sending a request using ResumeGameServerGroupRequest.
//    req := client.ResumeGameServerGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup
func (c *Client) ResumeGameServerGroupRequest(input *ResumeGameServerGroupInput) ResumeGameServerGroupRequest {
	op := &aws.Operation{
		Name:       opResumeGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeGameServerGroupInput{}
	}

	req := c.newRequest(op, input, &ResumeGameServerGroupOutput{})

	return ResumeGameServerGroupRequest{Request: req, Input: input, Copy: c.ResumeGameServerGroupRequest}
}

// ResumeGameServerGroupRequest is the request type for the
// ResumeGameServerGroup API operation.
type ResumeGameServerGroupRequest struct {
	*aws.Request
	Input *ResumeGameServerGroupInput
	Copy  func(*ResumeGameServerGroupInput) ResumeGameServerGroupRequest
}

// Send marshals and sends the ResumeGameServerGroup API request.
func (r ResumeGameServerGroupRequest) Send(ctx context.Context) (*ResumeGameServerGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResumeGameServerGroupResponse{
		ResumeGameServerGroupOutput: r.Request.Data.(*ResumeGameServerGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResumeGameServerGroupResponse is the response type for the
// ResumeGameServerGroup API operation.
type ResumeGameServerGroupResponse struct {
	*ResumeGameServerGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResumeGameServerGroup request.
func (r *ResumeGameServerGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
