// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateGameServerInput struct {
	_ struct{} `type:"structure"`

	// A game server tag that can be used to request sorted lists of game servers
	// using ListGameServers. Custom sort keys are developer-defined based on how
	// you want to organize the retrieved game server information.
	CustomSortKey *string `min:"1" type:"string"`

	// A set of custom game server properties, formatted as a single string value.
	// This data is passed to a game client or service when it requests information
	// on a game servers using DescribeGameServer or ClaimGameServer.
	GameServerData *string `min:"1" type:"string"`

	// An identifier for the game server group where the game server is running.
	// Use either the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// The identifier for the game server to be updated.
	//
	// GameServerId is a required field
	GameServerId *string `min:"3" type:"string" required:"true"`

	// Indicates health status of the game server. An update that explicitly includes
	// this parameter updates the game server's LastHealthCheckTime time stamp.
	HealthCheck GameServerHealthCheck `type:"string" enum:"true"`

	// Indicates whether the game server is available or is currently hosting gameplay.
	UtilizationStatus GameServerUtilizationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGameServerInput"}
	if s.CustomSortKey != nil && len(*s.CustomSortKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomSortKey", 1))
	}
	if s.GameServerData != nil && len(*s.GameServerData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerData", 1))
	}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if s.GameServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerId"))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateGameServerOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly updated game server resource.
	GameServer *GameServer `type:"structure"`
}

// String returns the string representation
func (s UpdateGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGameServer = "UpdateGameServer"

// UpdateGameServerRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Updates information about a registered game server. This action is called
// by a game server process that is running on an instance in a game server
// group. There are three reasons to update game server information: (1) to
// change the utilization status of the game server, (2) to report game server
// health status, and (3) to change game server metadata. A registered game
// server should regularly report health and should update utilization status
// when it is supporting gameplay so that GameLift FleetIQ can accurately track
// game server availability. You can make all three types of updates in the
// same request.
//
//    * To update the game server's utilization status, identify the game server
//    and game server group and specify the current utilization status. Use
//    this status to identify when game servers are currently hosting games
//    and when they are available to be claimed.
//
//    * To report health status, identify the game server and game server group
//    and set health check to HEALTHY. If a game server does not report health
//    status for a certain length of time, the game server is no longer considered
//    healthy and will be eventually de-registered from the game server group
//    to avoid affecting utilization metrics. The best practice is to report
//    health every 60 seconds.
//
//    * To change game server metadata, provide updated game server data and
//    custom sort key values.
//
// Once a game server is successfully updated, the relevant statuses and timestamps
// are updated.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * RegisterGameServer
//
//    * ListGameServers
//
//    * ClaimGameServer
//
//    * DescribeGameServer
//
//    * UpdateGameServer
//
//    * DeregisterGameServer
//
//    // Example sending a request using UpdateGameServerRequest.
//    req := client.UpdateGameServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServer
func (c *Client) UpdateGameServerRequest(input *UpdateGameServerInput) UpdateGameServerRequest {
	op := &aws.Operation{
		Name:       opUpdateGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameServerInput{}
	}

	req := c.newRequest(op, input, &UpdateGameServerOutput{})

	return UpdateGameServerRequest{Request: req, Input: input, Copy: c.UpdateGameServerRequest}
}

// UpdateGameServerRequest is the request type for the
// UpdateGameServer API operation.
type UpdateGameServerRequest struct {
	*aws.Request
	Input *UpdateGameServerInput
	Copy  func(*UpdateGameServerInput) UpdateGameServerRequest
}

// Send marshals and sends the UpdateGameServer API request.
func (r UpdateGameServerRequest) Send(ctx context.Context) (*UpdateGameServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGameServerResponse{
		UpdateGameServerOutput: r.Request.Data.(*UpdateGameServerOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGameServerResponse is the response type for the
// UpdateGameServer API operation.
type UpdateGameServerResponse struct {
	*UpdateGameServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGameServer request.
func (r *UpdateGameServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
