// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// The fallback balancing method to use for the game server group when Spot
	// instances in a Region become unavailable or are not viable for game hosting.
	// Once triggered, this method remains active until Spot instances can once
	// again be used. Method options include:
	//
	//    * SPOT_ONLY -- If Spot instances are unavailable, the game server group
	//    provides no hosting capacity. No new instances are started, and the existing
	//    nonviable Spot instances are terminated (once current gameplay ends) and
	//    not replaced.
	//
	//    * SPOT_PREFERRED -- If Spot instances are unavailable, the game server
	//    group continues to provide hosting capacity by using On-Demand instances.
	//    Existing nonviable Spot instances are terminated (once current gameplay
	//    ends) and replaced with new On-Demand instances.
	BalancingStrategy BalancingStrategy `type:"string" enum:"true"`

	// The unique identifier of the game server group to update. Use either the
	// GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A flag that indicates whether instances in the game server group are protected
	// from early termination. Unprotected instances that have active game servers
	// running may by terminated during a scale-down event, causing players to be
	// dropped from the game. Protected instances cannot be terminated while there
	// are active game servers running. An exception to this is Spot Instances,
	// which may be terminated by AWS regardless of protection status. This property
	// is set to NO_PROTECTION by default.
	GameServerProtectionPolicy GameServerProtectionPolicy `type:"string" enum:"true"`

	// An updated list of EC2 instance types to use when creating instances in the
	// group. The instance definition must specify instance types that are supported
	// by GameLift FleetIQ, and must include at least two instance types. This updated
	// list replaces the entire current list of instance definitions for the game
	// server group. For more information on instance types, see EC2 Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon EC2 User Guide..
	InstanceDefinitions []InstanceDefinition `min:"2" type:"list"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling
	// groups. The submitted role is validated to ensure that it contains the necessary
	// permissions for game server groups.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameServerGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGameServerGroupInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.InstanceDefinitions != nil && len(s.InstanceDefinitions) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceDefinitions", 2))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.InstanceDefinitions != nil {
		for i, v := range s.InstanceDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the game server group resource with updated properties.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGameServerGroup = "UpdateGameServerGroup"

// UpdateGameServerGroupRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Updates GameLift FleetIQ-specific properties for a game server group. These
// properties include instance rebalancing and game server protection. Many
// Auto Scaling group properties are updated directly. These include autoscaling
// policies, minimum/maximum/desired instance counts, and launch template.
//
// To update the game server group, specify the game server group ID and provide
// the updated values.
//
// Updated properties are validated to ensure that GameLift FleetIQ can continue
// to perform its core instance rebalancing activity. When you change Auto Scaling
// group properties directly and the changes cause errors with GameLift FleetIQ
// activities, an alert is sent.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Updating a GameLift FleetIQ-Linked Auto Scaling Group (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-asgroups.html)
//
// Related operations
//
//    * CreateGameServerGroup
//
//    * ListGameServerGroups
//
//    * DescribeGameServerGroup
//
//    * UpdateGameServerGroup
//
//    * DeleteGameServerGroup
//
//    * ResumeGameServerGroup
//
//    * SuspendGameServerGroup
//
//    // Example sending a request using UpdateGameServerGroupRequest.
//    req := client.UpdateGameServerGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServerGroup
func (c *Client) UpdateGameServerGroupRequest(input *UpdateGameServerGroupInput) UpdateGameServerGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameServerGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateGameServerGroupOutput{})

	return UpdateGameServerGroupRequest{Request: req, Input: input, Copy: c.UpdateGameServerGroupRequest}
}

// UpdateGameServerGroupRequest is the request type for the
// UpdateGameServerGroup API operation.
type UpdateGameServerGroupRequest struct {
	*aws.Request
	Input *UpdateGameServerGroupInput
	Copy  func(*UpdateGameServerGroupInput) UpdateGameServerGroupRequest
}

// Send marshals and sends the UpdateGameServerGroup API request.
func (r UpdateGameServerGroupRequest) Send(ctx context.Context) (*UpdateGameServerGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGameServerGroupResponse{
		UpdateGameServerGroupOutput: r.Request.Data.(*UpdateGameServerGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGameServerGroupResponse is the response type for the
// UpdateGameServerGroup API operation.
type UpdateGameServerGroupResponse struct {
	*UpdateGameServerGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGameServerGroup request.
func (r *UpdateGameServerGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
