// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetJobBookmarkInput struct {
	_ struct{} `type:"structure"`

	// The name of the job in question.
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`

	// The unique run identifier associated with this job run.
	RunId *string `type:"string"`
}

// String returns the string representation
func (s GetJobBookmarkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobBookmarkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJobBookmarkInput"}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobBookmarkOutput struct {
	_ struct{} `type:"structure"`

	// A structure that defines a point that a job can resume processing.
	JobBookmarkEntry *JobBookmarkEntry `type:"structure"`
}

// String returns the string representation
func (s GetJobBookmarkOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetJobBookmark = "GetJobBookmark"

// GetJobBookmarkRequest returns a request value for making API operation for
// AWS Glue.
//
// Returns information on a job bookmark entry.
//
//    // Example sending a request using GetJobBookmarkRequest.
//    req := client.GetJobBookmarkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark
func (c *Client) GetJobBookmarkRequest(input *GetJobBookmarkInput) GetJobBookmarkRequest {
	op := &aws.Operation{
		Name:       opGetJobBookmark,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobBookmarkInput{}
	}

	req := c.newRequest(op, input, &GetJobBookmarkOutput{})

	return GetJobBookmarkRequest{Request: req, Input: input, Copy: c.GetJobBookmarkRequest}
}

// GetJobBookmarkRequest is the request type for the
// GetJobBookmark API operation.
type GetJobBookmarkRequest struct {
	*aws.Request
	Input *GetJobBookmarkInput
	Copy  func(*GetJobBookmarkInput) GetJobBookmarkRequest
}

// Send marshals and sends the GetJobBookmark API request.
func (r GetJobBookmarkRequest) Send(ctx context.Context) (*GetJobBookmarkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJobBookmarkResponse{
		GetJobBookmarkOutput: r.Request.Data.(*GetJobBookmarkOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJobBookmarkResponse is the response type for the
// GetJobBookmark API operation.
type GetJobBookmarkResponse struct {
	*GetJobBookmarkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJobBookmark request.
func (r *GetJobBookmarkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
