// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetFindingsStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose findings'
	// statistics you want to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Represents the criteria that is used for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// The types of finding statistics to retrieve.
	//
	// FindingStatisticTypes is a required field
	FindingStatisticTypes []FindingStatisticType `locationName:"findingStatisticTypes" type:"list" required:"true"`
}

// String returns the string representation
func (s GetFindingsStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsStatisticsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFindingsStatisticsInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.FindingStatisticTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingStatisticTypes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingsStatisticsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.FindingStatisticTypes != nil {
		v := s.FindingStatisticTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingStatisticTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetFindingsStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The finding statistics object.
	//
	// FindingStatistics is a required field
	FindingStatistics *FindingStatistics `locationName:"findingStatistics" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetFindingsStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingsStatisticsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingStatistics != nil {
		v := s.FindingStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingStatistics", v, metadata)
	}
	return nil
}

const opGetFindingsStatistics = "GetFindingsStatistics"

// GetFindingsStatisticsRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Lists Amazon GuardDuty findings statistics for the specified detector ID.
//
//    // Example sending a request using GetFindingsStatisticsRequest.
//    req := client.GetFindingsStatisticsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics
func (c *Client) GetFindingsStatisticsRequest(input *GetFindingsStatisticsInput) GetFindingsStatisticsRequest {
	op := &aws.Operation{
		Name:       opGetFindingsStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/statistics",
	}

	if input == nil {
		input = &GetFindingsStatisticsInput{}
	}

	req := c.newRequest(op, input, &GetFindingsStatisticsOutput{})

	return GetFindingsStatisticsRequest{Request: req, Input: input, Copy: c.GetFindingsStatisticsRequest}
}

// GetFindingsStatisticsRequest is the request type for the
// GetFindingsStatistics API operation.
type GetFindingsStatisticsRequest struct {
	*aws.Request
	Input *GetFindingsStatisticsInput
	Copy  func(*GetFindingsStatisticsInput) GetFindingsStatisticsRequest
}

// Send marshals and sends the GetFindingsStatistics API request.
func (r GetFindingsStatisticsRequest) Send(ctx context.Context) (*GetFindingsStatisticsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFindingsStatisticsResponse{
		GetFindingsStatisticsOutput: r.Request.Data.(*GetFindingsStatisticsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFindingsStatisticsResponse is the response type for the
// GetFindingsStatistics API operation.
type GetFindingsStatisticsResponse struct {
	*GetFindingsStatisticsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFindingsStatistics request.
func (r *GetFindingsStatisticsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
