// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEventAggregatesInput struct {
	_ struct{} `type:"structure"`

	// The only currently supported value is eventTypeCategory.
	//
	// AggregateField is a required field
	AggregateField EventAggregateField `locationName:"aggregateField" type:"string" required:"true" enum:"true"`

	// Values to narrow the results returned.
	Filter *EventFilter `locationName:"filter" type:"structure"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEventAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventAggregatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEventAggregatesInput"}
	if len(s.AggregateField) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AggregateField"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEventAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The number of events in each category that meet the optional filter criteria.
	EventAggregates []EventAggregate `locationName:"eventAggregates" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEventAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEventAggregates = "DescribeEventAggregates"

// DescribeEventAggregatesRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns the number of events of each event type (issue, scheduled change,
// and account notification). If no filter is specified, the counts of all events
// in each category are returned.
//
//    // Example sending a request using DescribeEventAggregatesRequest.
//    req := client.DescribeEventAggregatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates
func (c *Client) DescribeEventAggregatesRequest(input *DescribeEventAggregatesInput) DescribeEventAggregatesRequest {
	op := &aws.Operation{
		Name:       opDescribeEventAggregates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventAggregatesInput{}
	}

	req := c.newRequest(op, input, &DescribeEventAggregatesOutput{})

	return DescribeEventAggregatesRequest{Request: req, Input: input, Copy: c.DescribeEventAggregatesRequest}
}

// DescribeEventAggregatesRequest is the request type for the
// DescribeEventAggregates API operation.
type DescribeEventAggregatesRequest struct {
	*aws.Request
	Input *DescribeEventAggregatesInput
	Copy  func(*DescribeEventAggregatesInput) DescribeEventAggregatesRequest
}

// Send marshals and sends the DescribeEventAggregates API request.
func (r DescribeEventAggregatesRequest) Send(ctx context.Context) (*DescribeEventAggregatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventAggregatesResponse{
		DescribeEventAggregatesOutput: r.Request.Data.(*DescribeEventAggregatesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeEventAggregatesRequestPaginator returns a paginator for DescribeEventAggregates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeEventAggregatesRequest(input)
//   p := health.NewDescribeEventAggregatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeEventAggregatesPaginator(req DescribeEventAggregatesRequest) DescribeEventAggregatesPaginator {
	return DescribeEventAggregatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeEventAggregatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeEventAggregatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeEventAggregatesPaginator struct {
	aws.Pager
}

func (p *DescribeEventAggregatesPaginator) CurrentPage() *DescribeEventAggregatesOutput {
	return p.Pager.CurrentPage().(*DescribeEventAggregatesOutput)
}

// DescribeEventAggregatesResponse is the response type for the
// DescribeEventAggregates API operation.
type DescribeEventAggregatesResponse struct {
	*DescribeEventAggregatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventAggregates request.
func (r *DescribeEventAggregatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
