// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the user who the policy is associated with.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUserPolicyInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetUserPolicy request.
type GetUserPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// IAM stores policies in JSON format. However, resources that were created
	// using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation
	// always converts a YAML policy to JSON format before submitting it to IAM.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The user the policy is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetUserPolicy = "GetUserPolicy"

// GetUserPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded in the specified
// IAM user.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM user can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a user, use GetPolicy to determine
// the policy's default version. Then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using GetUserPolicyRequest.
//    req := client.GetUserPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy
func (c *Client) GetUserPolicyRequest(input *GetUserPolicyInput) GetUserPolicyRequest {
	op := &aws.Operation{
		Name:       opGetUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserPolicyInput{}
	}

	req := c.newRequest(op, input, &GetUserPolicyOutput{})

	return GetUserPolicyRequest{Request: req, Input: input, Copy: c.GetUserPolicyRequest}
}

// GetUserPolicyRequest is the request type for the
// GetUserPolicy API operation.
type GetUserPolicyRequest struct {
	*aws.Request
	Input *GetUserPolicyInput
	Copy  func(*GetUserPolicyInput) GetUserPolicyRequest
}

// Send marshals and sends the GetUserPolicy API request.
func (r GetUserPolicyRequest) Send(ctx context.Context) (*GetUserPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUserPolicyResponse{
		GetUserPolicyOutput: r.Request.Data.(*GetUserPolicyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUserPolicyResponse is the response type for the
// GetUserPolicy API operation.
type GetUserPolicyResponse struct {
	*GetUserPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUserPolicy request.
func (r *GetUserPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
