// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListServiceSpecificCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Filters the returned results to only those for the specified AWS service.
	// If not specified, then AWS returns service-specific credentials for all services.
	ServiceName *string `type:"string"`

	// The name of the user whose service-specific credentials you want information
	// about. If this value is not specified, then the operation assumes the user
	// whose credentials are used to call the operation.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServiceSpecificCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceSpecificCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListServiceSpecificCredentialsInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListServiceSpecificCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A list of structures that each contain details about a service-specific credential.
	ServiceSpecificCredentials []ServiceSpecificCredentialMetadata `type:"list"`
}

// String returns the string representation
func (s ListServiceSpecificCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListServiceSpecificCredentials = "ListServiceSpecificCredentials"

// ListServiceSpecificCredentialsRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Returns information about the service-specific credentials associated with
// the specified IAM user. If none exists, the operation returns an empty list.
// The service-specific credentials returned by this operation are used only
// for authenticating the IAM user to a specific service. For more information
// about using service-specific credentials to authenticate to an AWS service,
// see Set Up service-specific credentials (https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html)
// in the AWS CodeCommit User Guide.
//
//    // Example sending a request using ListServiceSpecificCredentialsRequest.
//    req := client.ListServiceSpecificCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials
func (c *Client) ListServiceSpecificCredentialsRequest(input *ListServiceSpecificCredentialsInput) ListServiceSpecificCredentialsRequest {
	op := &aws.Operation{
		Name:       opListServiceSpecificCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServiceSpecificCredentialsInput{}
	}

	req := c.newRequest(op, input, &ListServiceSpecificCredentialsOutput{})

	return ListServiceSpecificCredentialsRequest{Request: req, Input: input, Copy: c.ListServiceSpecificCredentialsRequest}
}

// ListServiceSpecificCredentialsRequest is the request type for the
// ListServiceSpecificCredentials API operation.
type ListServiceSpecificCredentialsRequest struct {
	*aws.Request
	Input *ListServiceSpecificCredentialsInput
	Copy  func(*ListServiceSpecificCredentialsInput) ListServiceSpecificCredentialsRequest
}

// Send marshals and sends the ListServiceSpecificCredentials API request.
func (r ListServiceSpecificCredentialsRequest) Send(ctx context.Context) (*ListServiceSpecificCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListServiceSpecificCredentialsResponse{
		ListServiceSpecificCredentialsOutput: r.Request.Data.(*ListServiceSpecificCredentialsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListServiceSpecificCredentialsResponse is the response type for the
// ListServiceSpecificCredentials API operation.
type ListServiceSpecificCredentialsResponse struct {
	*ListServiceSpecificCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListServiceSpecificCredentials request.
func (r *ListServiceSpecificCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
