// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateProvisioningClaimInput struct {
	_ struct{} `type:"structure"`

	// The name of the provisioning template to use.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningClaimInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningClaimInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateProvisioningClaimInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProvisioningClaimInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateProvisioningClaimOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The provisioning claim certificate.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The provisioning claim expiration time.
	Expiration *time.Time `locationName:"expiration" type:"timestamp"`

	// The provisioning claim key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateProvisioningClaimOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProvisioningClaimOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificatePem != nil {
		v := *s.CertificatePem

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificatePem", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expiration",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.KeyPair != nil {
		v := s.KeyPair

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "keyPair", v, metadata)
	}
	return nil
}

const opCreateProvisioningClaim = "CreateProvisioningClaim"

// CreateProvisioningClaimRequest returns a request value for making API operation for
// AWS IoT.
//
// Creates a provisioning claim.
//
//    // Example sending a request using CreateProvisioningClaimRequest.
//    req := client.CreateProvisioningClaimRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateProvisioningClaimRequest(input *CreateProvisioningClaimInput) CreateProvisioningClaimRequest {
	op := &aws.Operation{
		Name:       opCreateProvisioningClaim,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioning-templates/{templateName}/provisioning-claim",
	}

	if input == nil {
		input = &CreateProvisioningClaimInput{}
	}

	req := c.newRequest(op, input, &CreateProvisioningClaimOutput{})

	return CreateProvisioningClaimRequest{Request: req, Input: input, Copy: c.CreateProvisioningClaimRequest}
}

// CreateProvisioningClaimRequest is the request type for the
// CreateProvisioningClaim API operation.
type CreateProvisioningClaimRequest struct {
	*aws.Request
	Input *CreateProvisioningClaimInput
	Copy  func(*CreateProvisioningClaimInput) CreateProvisioningClaimRequest
}

// Send marshals and sends the CreateProvisioningClaim API request.
func (r CreateProvisioningClaimRequest) Send(ctx context.Context) (*CreateProvisioningClaimResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateProvisioningClaimResponse{
		CreateProvisioningClaimOutput: r.Request.Data.(*CreateProvisioningClaimOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateProvisioningClaimResponse is the response type for the
// CreateProvisioningClaim API operation.
type CreateProvisioningClaimResponse struct {
	*CreateProvisioningClaimOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateProvisioningClaim request.
func (r *CreateProvisioningClaimResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
