// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDimensionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the dimension that you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDimensionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDimensionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDimensionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDimensionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDimensionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDimension = "DeleteDimension"

// DeleteDimensionRequest returns a request value for making API operation for
// AWS IoT.
//
// Removes the specified dimension from your AWS account.
//
//    // Example sending a request using DeleteDimensionRequest.
//    req := client.DeleteDimensionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteDimensionRequest(input *DeleteDimensionInput) DeleteDimensionRequest {
	op := &aws.Operation{
		Name:       opDeleteDimension,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &DeleteDimensionInput{}
	}

	req := c.newRequest(op, input, &DeleteDimensionOutput{})

	return DeleteDimensionRequest{Request: req, Input: input, Copy: c.DeleteDimensionRequest}
}

// DeleteDimensionRequest is the request type for the
// DeleteDimension API operation.
type DeleteDimensionRequest struct {
	*aws.Request
	Input *DeleteDimensionInput
	Copy  func(*DeleteDimensionInput) DeleteDimensionRequest
}

// Send marshals and sends the DeleteDimension API request.
func (r DeleteDimensionRequest) Send(ctx context.Context) (*DeleteDimensionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDimensionResponse{
		DeleteDimensionOutput: r.Request.Data.(*DeleteDimensionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDimensionResponse is the response type for the
// DeleteDimension API operation.
type DeleteDimensionResponse struct {
	*DeleteDimensionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDimension request.
func (r *DeleteDimensionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
