// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model from which to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset. For more information,
	// see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAssetInput"}

	if s.AssetModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelId", 36))
	}

	if s.AssetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAssetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetName != nil {
		v := *s.AssetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The ID of the asset. This ID uniquely identifies the asset within AWS IoT
	// SiteWise and can be used with other AWS IoT SiteWise APIs.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The status of the asset, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAssetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetArn != nil {
		v := *s.AssetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetStatus != nil {
		v := s.AssetStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assetStatus", v, metadata)
	}
	return nil
}

const opCreateAsset = "CreateAsset"

// CreateAssetRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Creates an asset from an existing asset model. For more information, see
// Creating Assets (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html)
// in the AWS IoT SiteWise User Guide.
//
//    // Example sending a request using CreateAssetRequest.
//    req := client.CreateAssetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset
func (c *Client) CreateAssetRequest(input *CreateAssetInput) CreateAssetRequest {
	op := &aws.Operation{
		Name:       opCreateAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/assets",
	}

	if input == nil {
		input = &CreateAssetInput{}
	}

	req := c.newRequest(op, input, &CreateAssetOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return CreateAssetRequest{Request: req, Input: input, Copy: c.CreateAssetRequest}
}

// CreateAssetRequest is the request type for the
// CreateAsset API operation.
type CreateAssetRequest struct {
	*aws.Request
	Input *CreateAssetInput
	Copy  func(*CreateAssetInput) CreateAssetRequest
}

// Send marshals and sends the CreateAsset API request.
func (r CreateAssetRequest) Send(ctx context.Context) (*CreateAssetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAssetResponse{
		CreateAssetOutput: r.Request.Data.(*CreateAssetOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAssetResponse is the response type for the
// CreateAsset API operation.
type CreateAssetResponse struct {
	*CreateAssetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAsset request.
func (r *CreateAssetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
