// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the dashboard to delete.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "dashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDashboardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Deletes a dashboard from AWS IoT SiteWise Monitor.
//
//    // Example sending a request using DeleteDashboardRequest.
//    req := client.DeleteDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard
func (c *Client) DeleteDashboardRequest(input *DeleteDashboardInput) DeleteDashboardRequest {
	op := &aws.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	req := c.newRequest(op, input, &DeleteDashboardOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DeleteDashboardRequest{Request: req, Input: input, Copy: c.DeleteDashboardRequest}
}

// DeleteDashboardRequest is the request type for the
// DeleteDashboard API operation.
type DeleteDashboardRequest struct {
	*aws.Request
	Input *DeleteDashboardInput
	Copy  func(*DeleteDashboardInput) DeleteDashboardRequest
}

// Send marshals and sends the DeleteDashboard API request.
func (r DeleteDashboardRequest) Send(ctx context.Context) (*DeleteDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDashboardResponse{
		DeleteDashboardOutput: r.Request.Data.(*DeleteDashboardOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDashboardResponse is the response type for the
// DeleteDashboard API operation.
type DeleteDashboardResponse struct {
	*DeleteDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDashboard request.
func (r *DeleteDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
