// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAssetInput"}

	if s.AssetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAssetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// AssetCreationDate is a required field
	AssetCreationDate *time.Time `locationName:"assetCreationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// AssetHierarchies is a required field
	AssetHierarchies []AssetHierarchy `locationName:"assetHierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// AssetLastUpdateDate is a required field
	AssetLastUpdateDate *time.Time `locationName:"assetLastUpdateDate" type:"timestamp" required:"true"`

	// The ID of the asset model that was used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// The list of asset properties for the asset.
	//
	// AssetProperties is a required field
	AssetProperties []AssetProperty `locationName:"assetProperties" type:"list" required:"true"`

	// The current status of the asset, which contains a state and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAssetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetArn != nil {
		v := *s.AssetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetCreationDate != nil {
		v := *s.AssetCreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetCreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.AssetHierarchies != nil {
		v := s.AssetHierarchies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetHierarchies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetLastUpdateDate != nil {
		v := *s.AssetLastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetLastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetName != nil {
		v := *s.AssetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetProperties != nil {
		v := s.AssetProperties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetProperties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AssetStatus != nil {
		v := s.AssetStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assetStatus", v, metadata)
	}
	return nil
}

const opDescribeAsset = "DescribeAsset"

// DescribeAssetRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves information about an asset.
//
//    // Example sending a request using DescribeAssetRequest.
//    req := client.DescribeAssetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset
func (c *Client) DescribeAssetRequest(input *DescribeAssetInput) DescribeAssetRequest {
	op := &aws.Operation{
		Name:       opDescribeAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DescribeAssetInput{}
	}

	req := c.newRequest(op, input, &DescribeAssetOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribeAssetRequest{Request: req, Input: input, Copy: c.DescribeAssetRequest}
}

// DescribeAssetRequest is the request type for the
// DescribeAsset API operation.
type DescribeAssetRequest struct {
	*aws.Request
	Input *DescribeAssetInput
	Copy  func(*DescribeAssetInput) DescribeAssetRequest
}

// Send marshals and sends the DescribeAsset API request.
func (r DescribeAssetRequest) Send(ctx context.Context) (*DescribeAssetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAssetResponse{
		DescribeAssetOutput: r.Request.Data.(*DescribeAssetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAssetResponse is the response type for the
// DescribeAsset API operation.
type DescribeAssetResponse struct {
	*DescribeAssetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAsset request.
func (r *DescribeAssetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
