// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDashboardInput"}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "dashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The date the dashboard was created, in Unix epoch time.
	//
	// DashboardCreationDate is a required field
	DashboardCreationDate *time.Time `locationName:"dashboardCreationDate" type:"timestamp" required:"true"`

	// The dashboard's definition JSON literal. For detailed information, see Creating
	// Dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// The dashboard's description.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	//
	// DashboardLastUpdateDate is a required field
	DashboardLastUpdateDate *time.Time `locationName:"dashboardLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project that the dashboard is in.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DashboardArn != nil {
		v := *s.DashboardArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardCreationDate != nil {
		v := *s.DashboardCreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardCreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DashboardDefinition != nil {
		v := *s.DashboardDefinition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardDefinition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardDescription != nil {
		v := *s.DashboardDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardLastUpdateDate != nil {
		v := *s.DashboardLastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardLastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DashboardName != nil {
		v := *s.DashboardName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves information about a dashboard.
//
//    // Example sending a request using DescribeDashboardRequest.
//    req := client.DescribeDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard
func (c *Client) DescribeDashboardRequest(input *DescribeDashboardInput) DescribeDashboardRequest {
	op := &aws.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	req := c.newRequest(op, input, &DescribeDashboardOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribeDashboardRequest{Request: req, Input: input, Copy: c.DescribeDashboardRequest}
}

// DescribeDashboardRequest is the request type for the
// DescribeDashboard API operation.
type DescribeDashboardRequest struct {
	*aws.Request
	Input *DescribeDashboardInput
	Copy  func(*DescribeDashboardInput) DescribeDashboardRequest
}

// Send marshals and sends the DescribeDashboard API request.
func (r DescribeDashboardRequest) Send(ctx context.Context) (*DescribeDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDashboardResponse{
		DescribeDashboardOutput: r.Request.Data.(*DescribeDashboardOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDashboardResponse is the response type for the
// DescribeDashboard API operation.
type DescribeDashboardResponse struct {
	*DescribeDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDashboard request.
func (r *DescribeDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
