// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateGatewayCapabilityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that defines the configuration for the gateway capability.
	// For more information, see Configuring data sources (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli)
	// in the AWS IoT SiteWise User Guide.
	//
	// CapabilityConfiguration is a required field
	CapabilityConfiguration *string `locationName:"capabilityConfiguration" min:"1" type:"string" required:"true"`

	// The namespace of the gateway capability configuration to be updated. For
	// example, if you configure OPC-UA sources from the AWS IoT SiteWise console,
	// your OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:version,
	// where version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The ID of the gateway to be updated.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewayCapabilityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayCapabilityConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGatewayCapabilityConfigurationInput"}

	if s.CapabilityConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("CapabilityConfiguration"))
	}
	if s.CapabilityConfiguration != nil && len(*s.CapabilityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CapabilityConfiguration", 1))
	}

	if s.CapabilityNamespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("CapabilityNamespace"))
	}
	if s.CapabilityNamespace != nil && len(*s.CapabilityNamespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CapabilityNamespace", 1))
	}

	if s.GatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGatewayCapabilityConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CapabilityConfiguration != nil {
		v := *s.CapabilityConfiguration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilityConfiguration", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CapabilityNamespace != nil {
		v := *s.CapabilityNamespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilityNamespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayId != nil {
		v := *s.GatewayId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "gatewayId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateGatewayCapabilityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The namespace of the gateway capability.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// After you update a capability configuration, its sync status is OUT_OF_SYNC
	// until the gateway receives and applies or rejects the updated configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus CapabilitySyncStatus `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateGatewayCapabilityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGatewayCapabilityConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CapabilityNamespace != nil {
		v := *s.CapabilityNamespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilityNamespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CapabilitySyncStatus) > 0 {
		v := s.CapabilitySyncStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilitySyncStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opUpdateGatewayCapabilityConfiguration = "UpdateGatewayCapabilityConfiguration"

// UpdateGatewayCapabilityConfigurationRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Updates a gateway capability configuration or defines a new capability configuration.
// Each gateway capability defines data sources for a gateway. A capability
// configuration can contain multiple data source configurations. If you define
// OPC-UA sources for a gateway in the AWS IoT SiteWise console, all of your
// OPC-UA sources are stored in one capability configuration. To list all capability
// configurations for a gateway, use DescribeGateway (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html).
//
//    // Example sending a request using UpdateGatewayCapabilityConfigurationRequest.
//    req := client.UpdateGatewayCapabilityConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration
func (c *Client) UpdateGatewayCapabilityConfigurationRequest(input *UpdateGatewayCapabilityConfigurationInput) UpdateGatewayCapabilityConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateGatewayCapabilityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/20200301/gateways/{gatewayId}/capability",
	}

	if input == nil {
		input = &UpdateGatewayCapabilityConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateGatewayCapabilityConfigurationOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return UpdateGatewayCapabilityConfigurationRequest{Request: req, Input: input, Copy: c.UpdateGatewayCapabilityConfigurationRequest}
}

// UpdateGatewayCapabilityConfigurationRequest is the request type for the
// UpdateGatewayCapabilityConfiguration API operation.
type UpdateGatewayCapabilityConfigurationRequest struct {
	*aws.Request
	Input *UpdateGatewayCapabilityConfigurationInput
	Copy  func(*UpdateGatewayCapabilityConfigurationInput) UpdateGatewayCapabilityConfigurationRequest
}

// Send marshals and sends the UpdateGatewayCapabilityConfiguration API request.
func (r UpdateGatewayCapabilityConfigurationRequest) Send(ctx context.Context) (*UpdateGatewayCapabilityConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGatewayCapabilityConfigurationResponse{
		UpdateGatewayCapabilityConfigurationOutput: r.Request.Data.(*UpdateGatewayCapabilityConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGatewayCapabilityConfigurationResponse is the response type for the
// UpdateGatewayCapabilityConfiguration API operation.
type UpdateGatewayCapabilityConfigurationResponse struct {
	*UpdateGatewayCapabilityConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGatewayCapabilityConfiguration request.
func (r *UpdateGatewayCapabilityConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
