// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN for the stream key to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetStreamKeyInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a stream key.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation
func (s GetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamKey != nil {
		v := s.StreamKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamKey", v, metadata)
	}
	return nil
}

const opGetStreamKey = "GetStreamKey"

// GetStreamKeyRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Gets stream-key information for a specified ARN.
//
//    // Example sending a request using GetStreamKeyRequest.
//    req := client.GetStreamKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey
func (c *Client) GetStreamKeyRequest(input *GetStreamKeyInput) GetStreamKeyRequest {
	op := &aws.Operation{
		Name:       opGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStreamKey",
	}

	if input == nil {
		input = &GetStreamKeyInput{}
	}

	req := c.newRequest(op, input, &GetStreamKeyOutput{})

	return GetStreamKeyRequest{Request: req, Input: input, Copy: c.GetStreamKeyRequest}
}

// GetStreamKeyRequest is the request type for the
// GetStreamKey API operation.
type GetStreamKeyRequest struct {
	*aws.Request
	Input *GetStreamKeyInput
	Copy  func(*GetStreamKeyInput) GetStreamKeyRequest
}

// Send marshals and sends the GetStreamKey API request.
func (r GetStreamKeyRequest) Send(ctx context.Context) (*GetStreamKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetStreamKeyResponse{
		GetStreamKeyOutput: r.Request.Data.(*GetStreamKeyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetStreamKeyResponse is the response type for the
// GetStreamKey API operation.
type GetStreamKeyResponse struct {
	*GetStreamKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetStreamKey request.
func (r *GetStreamKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
