// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCompatibleKafkaVersionsInput struct {
	_ struct{} `type:"structure"`

	ClusterArn *string `location:"querystring" locationName:"clusterArn" type:"string"`
}

// String returns the string representation
func (s GetCompatibleKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCompatibleKafkaVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClusterArn != nil {
		v := *s.ClusterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clusterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response body for GetCompatibleKafkaVersions.
type GetCompatibleKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CompatibleKafkaVersion objects.
	CompatibleKafkaVersions []CompatibleKafkaVersion `locationName:"compatibleKafkaVersions" type:"list"`
}

// String returns the string representation
func (s GetCompatibleKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCompatibleKafkaVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompatibleKafkaVersions != nil {
		v := s.CompatibleKafkaVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "compatibleKafkaVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetCompatibleKafkaVersions = "GetCompatibleKafkaVersions"

// GetCompatibleKafkaVersionsRequest returns a request value for making API operation for
// Managed Streaming for Kafka.
//
// Gets the Apache Kafka versions to which you can update the MSK cluster.
//
//    // Example sending a request using GetCompatibleKafkaVersionsRequest.
//    req := client.GetCompatibleKafkaVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions
func (c *Client) GetCompatibleKafkaVersionsRequest(input *GetCompatibleKafkaVersionsInput) GetCompatibleKafkaVersionsRequest {
	op := &aws.Operation{
		Name:       opGetCompatibleKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/compatible-kafka-versions",
	}

	if input == nil {
		input = &GetCompatibleKafkaVersionsInput{}
	}

	req := c.newRequest(op, input, &GetCompatibleKafkaVersionsOutput{})

	return GetCompatibleKafkaVersionsRequest{Request: req, Input: input, Copy: c.GetCompatibleKafkaVersionsRequest}
}

// GetCompatibleKafkaVersionsRequest is the request type for the
// GetCompatibleKafkaVersions API operation.
type GetCompatibleKafkaVersionsRequest struct {
	*aws.Request
	Input *GetCompatibleKafkaVersionsInput
	Copy  func(*GetCompatibleKafkaVersionsInput) GetCompatibleKafkaVersionsRequest
}

// Send marshals and sends the GetCompatibleKafkaVersions API request.
func (r GetCompatibleKafkaVersionsRequest) Send(ctx context.Context) (*GetCompatibleKafkaVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCompatibleKafkaVersionsResponse{
		GetCompatibleKafkaVersionsOutput: r.Request.Data.(*GetCompatibleKafkaVersionsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCompatibleKafkaVersionsResponse is the response type for the
// GetCompatibleKafkaVersions API operation.
type GetCompatibleKafkaVersionsResponse struct {
	*GetCompatibleKafkaVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCompatibleKafkaVersions request.
func (r *GetCompatibleKafkaVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
